/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.navigator.IssueClassifiedExportDialog;
import jp.valtech.bts.ui.navigator.NavigatorView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * {@link IssueClassifiedExportDialog 種類別ファイル出力ダイアログ}を開くアクションです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class OpenClassifiedExportDlgAction extends Action {
	
	/** 活性時のアイコン */
	private static final ImageDescriptor THIS_IMAGE = BtsPlugin.getInstance().getImageDescriptor("export.gif"); 
	/** 非活性時のアイコン */
	private static final ImageDescriptor THIS_IMAGE_DISABLE = BtsPlugin.getInstance().getImageDescriptor("export_disable.gif"); 

	
	/** このアクションの呼び出しもとのビューオブジェクト */
	private NavigatorView navigatorView;

	
	/**
	 * 呼び出し元のビューインスタンスを設定します。
	 * 
	 * @param		navigatorView			 呼び出し元のビューインスタンス
	 */
	public OpenClassifiedExportDlgAction(NavigatorView navigatorView) {
		super();
		this.navigatorView = navigatorView;
		setText(Messages.getString("OpenClassifiedExportDlgAction.0")); //$NON-NLS-1$
		setToolTipText(Messages.getString("OpenClassifiedExportDlgAction.1"));  //$NON-NLS-1$

		setImageDescriptor(THIS_IMAGE);
		setDisabledImageDescriptor(THIS_IMAGE_DISABLE);
	}


	/**
	 * {@link IssueClassifiedExportDialog}を開きます。
	 */
	public void run() {

		IssueClassifiedExportDialog issueClassifiedExportDialog = new IssueClassifiedExportDialog(navigatorView.getSite().getShell());
		issueClassifiedExportDialog.open();

	}
}
