/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.preference;

import jp.valtech.bts.ui.BtsPlugin;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * 共通設定画面（ネットワーク）を生成します。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class NetworkPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

	/** 1番目アドレスキー */
	public static final String ADDRESS1 = "Address1";
	/** 2番目アドレスキー */
	public static final String ADDRESS2 = "Address2";
	/** 3番目アドレスキー */
	public static final String ADDRESS3 = "Address3";
	/** 4番目アドレスキー */
	public static final String ADDRESS4 = "Address4";
	/** マルチキャスト通信ポート番号キー */
	public static final String MULTIPORT = "MultiPort";
	/** TCPデータ通信ポート番号キー */
	public static final String TCPPORT = "TcpPort";
	/** 配信処理タイムアウト */
	public static final String SEND_TIMEOUT = "Send_Timeout";
	/** 同期処理タイムアウト */
	public static final String SYNC_TIMEOUT = "Sync_Timeout";

	/** デフォルト 1番目アドレス */
	public static final int DEFAULT_ADDRESS1 = 224;
	/** デフォルト 2番目アドレス */
	public static final int DEFAULT_ADDRESS2 = 0;
	/** デフォルト 3番目アドレス */
	public static final int DEFAULT_ADDRESS3 = 0;
	/** デフォルト 4番目アドレス */
	public static final int DEFAULT_ADDRESS4 = 1;
	/** デフォルト マルチキャスト通信ポート番号 */
	public static final int DEFAULT_MULTIPORT = 4342;
	/** デフォルト TCPデータ通信ポート番号 */
	public static final int DEFAULT_TCPPORT = 4344;
	/** デフォルト 配信処理タイムアウト */
	public static final int DEFAULT_SEND_TIMEOUT = 10;
	/** デフォルト 同期処理タイムアウト */
	public static final int DEFAULT_SYNC_TIMEOUT = 25;

	/** テキストフィールド幅 */
	private static final int TEXT_FIELD_WIDTH = 6;

	public NetworkPreferencePage() {
		super(GRID);
		super.setPreferenceStore(BtsPlugin.getInstance().getPreferenceStore());
		initializeDefaults();
	}

	/**
	 * デフォルトの設定を行います。
	 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		store.setDefault(ADDRESS1, DEFAULT_ADDRESS1);
		store.setDefault(ADDRESS2, DEFAULT_ADDRESS2);
		store.setDefault(ADDRESS3, DEFAULT_ADDRESS3);
		store.setDefault(ADDRESS4, DEFAULT_ADDRESS4);
		store.setDefault(MULTIPORT, DEFAULT_MULTIPORT);
		store.setDefault(TCPPORT, DEFAULT_TCPPORT);
		store.setDefault(SEND_TIMEOUT, DEFAULT_SEND_TIMEOUT);
		store.setDefault(SYNC_TIMEOUT, DEFAULT_SYNC_TIMEOUT);
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.FieldEditorPreferencePage#createFieldEditors()
	 */
	protected void createFieldEditors() {
		// 親コンポジット取得
		Composite parent = getFieldEditorParent();
		// フィールドエディタのレイアウト設定
		parent = new Composite(parent, SWT.NONE);
		RowLayout rowLayout = new RowLayout(SWT.VERTICAL);
		rowLayout.spacing = 10;
		parent.setLayout(rowLayout);

		Label label = new Label(parent, SWT.NONE);
		label.setText(Messages.getString("NetworkPreferencePage.0")); //$NON-NLS-1$

		// マルチキャスト通信グループ生成
		Group multiGroup = new Group(parent, SWT.NONE);
		multiGroup.setText(Messages.getString("NetworkPreferencePage.1")); //$NON-NLS-1$

		// マルチキャスト通信グループのフィールドエディタ設定
		IntegerFieldEditor address1 = new IntegerFieldEditor(ADDRESS1, Messages.getString("NetworkPreferencePage.3"), multiGroup, 3); //$NON-NLS-1$
		IntegerFieldEditor address2 = new IntegerFieldEditor(ADDRESS2, ".", multiGroup, 3);
		IntegerFieldEditor address3 = new IntegerFieldEditor(ADDRESS3, ".", multiGroup, 3);
		IntegerFieldEditor address4 = new IntegerFieldEditor(ADDRESS4, ".", multiGroup, 3);
		IntegerFieldEditor multiPort = new IntegerFieldEditor(MULTIPORT, Messages.getString("NetworkPreferencePage.4"), multiGroup, 5); //$NON-NLS-1$

		// マルチキャスト通信グループのグリッドレイアウト設定
		GridLayout multiLayout = new GridLayout();
		multiLayout.numColumns = 8;
		multiLayout.marginRight = 110;
		multiGroup.setLayout(multiLayout);

		// TCP通信グループ生成
		Group tcpGroup = new Group(parent, SWT.NONE);
		tcpGroup.setText(Messages.getString("NetworkPreferencePage.2")); //$NON-NLS-1$

		// TCP通信グループのフィールドエディタ生成
		IntegerFieldEditor tcpPort = new IntegerFieldEditor(TCPPORT, Messages.getString("NetworkPreferencePage.5"), tcpGroup, 5); //$NON-NLS-1$

		// TCPデータ通信グループのグリッドレイアウト設定
		GridLayout tcpLayout = new GridLayout();
		tcpLayout.numColumns = 2;
		tcpLayout.marginRight = 258;
		tcpGroup.setLayout(tcpLayout);

		// タイムアウトグループ生成
		Group timeoutGroup = new Group(parent, SWT.NONE);
		timeoutGroup.setText(Messages.getString("NetworkPreferencePage.6")); //$NON-NLS-1$

		// タイムアウトグループのフィールドエディタ生成
		IntegerFieldEditor sendTimeout = new IntegerFieldEditor(SEND_TIMEOUT,
				Messages.getString("NetworkPreferencePage.7"), timeoutGroup, 2); //$NON-NLS-1$
		new Label(timeoutGroup, SWT.NONE).setText(Messages.getString("NetworkPreferencePage.8")); //$NON-NLS-1$
		IntegerFieldEditor syncTimeout = new IntegerFieldEditor(SYNC_TIMEOUT,
				Messages.getString("NetworkPreferencePage.9"), timeoutGroup, 2); //$NON-NLS-1$
		new Label(timeoutGroup, SWT.NONE).setText(Messages.getString("NetworkPreferencePage.10")); //$NON-NLS-1$

		// タイムアウトグループのグリッドレイアウト設定
		GridLayout timeoutLayout = new GridLayout();
		timeoutLayout.numColumns = 3;
		timeoutLayout.marginRight = 233;
		timeoutGroup.setLayout(timeoutLayout);

		// アドレステキストフィールドの固定幅を設定（1番目）
		((GridData) address1.getTextControl(multiGroup).getLayoutData()).widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
		// アドレステキストフィールドの固定幅を設定（2番目）
		((GridData) address2.getTextControl(multiGroup).getLayoutData()).widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
		// アドレステキストフィールドの固定幅を設定（3番目）
		((GridData) address3.getTextControl(multiGroup).getLayoutData()).widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
		// アドレステキストフィールドの固定幅を設定（4番目）
		((GridData) address4.getTextControl(multiGroup).getLayoutData()).widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
		// マルチキャストポート番号の固定幅を設定
		((GridData) multiPort.getTextControl(multiGroup).getLayoutData()).widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
		// TCPポート番号の固定幅を設定
		((GridData) tcpPort.getTextControl(tcpGroup).getLayoutData()).widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
		// 配信処理テキストフィールドの固定幅を設定
		((GridData) sendTimeout.getTextControl(timeoutGroup).getLayoutData()).widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
		// 同期処理テキストフィールドの固定幅を設定
		((GridData) syncTimeout.getTextControl(timeoutGroup).getLayoutData()).widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);

		// フィールドエディタ設定
		addField(address1);
		addField(address2);
		addField(address3);
		addField(address4);
		addField(multiPort);
		addField(tcpPort);
		addField(sendTimeout);
		addField(syncTimeout);

	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}

}
