/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.command.client;

import jp.valtech.bts.command.client.Messages;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.command.TCPClientCommand;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.Logging;

public class Ping
extends TCPClientCommand
implements Logging {
    private static final int PING_TIMEOUT = 4000;
    private String errorMsg;

    public Ping(NetworkConfig myconfig, String host, int port) {
        super(myconfig, host, port);
        this.setTimeout(4000);
    }

    public void execute() {
        try {
            Request request = new Request();
            request.setCommand("ping");
            String ssid = CurrentProject.getInsance().getSSID();
            request.setSSID(ssid);
            this.send(request);
            if (!this.isSuccessful()) {
                this.errorMsg = String.valueOf(Messages.getString("Ping.1")) + "\n addr=" + this.host + ", port=" + this.port + ", ssid=" + ssid;
            }
        }
        catch (Exception e) {
            this.errorMsg = String.valueOf(e.getMessage()) + "\n  addr=" + this.host + ", port=" + this.port;
            BtsPlugin.getInstance().errorlog(this.errorMsg, e);
        }
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }
}

