/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.command.client;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import jp.valtech.bts.command.client.Messages;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.facade.SyncClientFacade;
import jp.valtech.bts.facade.SyncHeaderFacade;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.Response;
import jp.valtech.bts.network.command.TCPClientCommand;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.RefreshAction;
import jp.valtech.bts.util.Logging;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SyncIssue
extends TCPClientCommand
implements Logging {
    private String userName;
    private boolean finished = false;

    public SyncIssue(NetworkConfig myconfig, String host, int port) {
        super(myconfig, host, port);
        this.setTimeout(myconfig.getSyncTimeout());
    }

    public void execute() {
        try {
            IRunnableWithProgress progress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Request request = new Request();
                    request.setCommand("syncIssue");
                    monitor.beginTask(Messages.getString("SyncIssue.1"), 5);
                    SyncHeaderFacade syncHeaderFacade = new SyncHeaderFacade();
                    List issueHeaderList = syncHeaderFacade.getIssueHeaderList();
                    request.addParameter("issueHeader", issueHeaderList);
                    monitor.worked(1);
                    List garbageHeaderList = syncHeaderFacade.getGarbageHeaderList();
                    request.addParameter("garbageHeader", garbageHeaderList);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException(Messages.getString("SyncIssue.4"));
                    }
                    try {
                        monitor.subTask("[ " + SyncIssue.this.userName + " (" + SyncIssue.this.host + Messages.getString("SyncIssue.2"));
                        Response response = SyncIssue.this.send(request);
                        monitor.worked(2);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException(Messages.getString("SyncIssue.4"));
                        }
                        if (!SyncIssue.this.isSuccessful()) {
                            throw new InterruptedException(response.getMessage());
                        }
                        Issue[] syncIssues = (Issue[])response.getParameterObject("syncIssues");
                        Issue[] syncGarbages = (Issue[])response.getParameterObject("syncGarbages");
                        SyncClientFacade syncFacade = new SyncClientFacade();
                        syncFacade.applySyncIssues(syncIssues, syncGarbages, monitor);
                        syncFacade.saveMessage(SyncIssue.this.userName, SyncIssue.this.host);
                        monitor.done();
                    }
                    catch (Exception e) {
                        logger.fatal((Object)Messages.getString("SyncIssue.5"), (Throwable)e);
                        throw new InterruptedException(e.getMessage());
                    }
                }
            };
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(BtsPlugin.getInstance().getShell());
            dialog.run(true, true, progress);
            RefreshAction refreshAction = new RefreshAction();
            refreshAction.run();
            this.finished = true;
        }
        catch (InvocationTargetException e) {
            BtsPlugin.getInstance().errorlog(e);
        }
        catch (InterruptedException e) {
            MessageDialog.openWarning((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("SyncIssue.3"), (String)e.getMessage());
        }
    }

    public void setRemoteUserName(String userName) {
        this.userName = userName;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

