/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.command.server;

import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.facade.ReceiveGarbageIssueFacade;
import jp.valtech.bts.facade.ReceiveReleaseIssueFacade;
import jp.valtech.bts.facade.VoteDAOFacade;
import jp.valtech.bts.network.Request;
import jp.valtech.bts.network.Response;
import jp.valtech.bts.network.command.TCPServerCommand;
import jp.valtech.bts.ui.BtsPlugin;

public class SendIssueServer
extends TCPServerCommand {
    public void execute(Request request, Response response, NetworkConfig myconfig) {
        Issue receiveIssue = (Issue)request.getParameterObject("issue");
        String fromUser = request.getParameterString("fromUser");
        if (receiveIssue == null) {
            response.setCode("error");
            response.setMessage("NullPointerException : request data is null");
            this.reply(response);
            return;
        }
        response.setCode("okay");
        this.reply(response);
        String fromAddr = this.getRequestClient().getHostAddress();
        logger.debug((Object)("FromUser    :" + fromUser + "(" + fromAddr + ")"));
        logger.debug((Object)("RequestIssue:" + receiveIssue.getTitle()));
        try {
            if ("R".equals(receiveIssue.getType())) {
                ReceiveReleaseIssueFacade facade = new ReceiveReleaseIssueFacade();
                facade.saveReceivedIssue(receiveIssue);
                facade.saveReceiveMessage(fromUser, fromAddr);
                VoteDAOFacade voteDAOFacade = new VoteDAOFacade();
                voteDAOFacade.cleanInsert(receiveIssue.getVotes());
            } else if ("G".equals(receiveIssue.getType())) {
                ReceiveGarbageIssueFacade facade = new ReceiveGarbageIssueFacade();
                facade.changeGarbageIssue(receiveIssue);
                facade.saveReceiveMessage(fromUser, fromAddr);
            }
        }
        catch (Exception e) {
            String msg = "failed 'send issue request'";
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }
}

