/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ResourceBundle;
import jp.valtech.bts.connection.Messages;
import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.Logging;

public abstract class DBConnection
implements Logging {
    private static final String SEPARATOR = System.getProperty("file.separator");
    protected static final String DB_FILE_PROPERTIES = ".properties";
    protected static final String DB_FILE_SCRIPT = ".script";
    private static final ResourceBundle resource = ResourceBundle.getBundle("connection");
    protected static final String CONNECTION_PREFIX = resource.getString("connection.prefix");
    protected static final String CONNECTION_SUFFIX = resource.getString("connection.suffix");
    private static final String DRIVER_CLASS = resource.getString("driver.class");
    protected Connection con = null;
    private int maxRetry = 20;
    private int retry = 0;
    protected String dbFilepath = "";

    static {
        try {
            Class.forName(DRIVER_CLASS);
        }
        catch (ClassNotFoundException e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
    }

    public DBConnection(String processType) {
        this(null, processType, null);
    }

    public DBConnection(String ssid, String processType) {
        this(ssid, processType, null);
    }

    public DBConnection(String ssid, String processType, String currentDir) {
        try {
            if (ssid == null) {
                ssid = CurrentProject.getInsance().getSSID();
            }
            if (currentDir == null) {
                currentDir = BtsPlugin.getInstance().getStateLocation().toString();
            }
            StringBuffer dbFilepath = new StringBuffer();
            dbFilepath.append(currentDir).append(SEPARATOR).append(ssid).append(SEPARATOR).append(processType);
            this.dbFilepath = dbFilepath.toString();
            this.buildConnection();
        }
        catch (BtsDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected void buildConnection() throws BtsDBException {
        StringBuffer dbURL = new StringBuffer();
        dbURL.append(CONNECTION_PREFIX);
        dbURL.append(this.dbFilepath);
        dbURL.append(CONNECTION_SUFFIX);
        logger.debug((Object)dbURL);
        try {
            this.con = DriverManager.getConnection(dbURL.toString());
            this.con.setAutoCommit(false);
            this.con.setReadOnly(false);
        }
        catch (SQLException e) {
            ++this.retry;
            if (this.retry > this.maxRetry) {
                String message = Messages.getString("DBConnection.6");
                throw new BtsDBException(message, e);
            }
            logger.info((Object)(String.valueOf(Messages.getString("DBConnection.7")) + this.retry));
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            this.buildConnection();
        }
    }

    public void commit() throws SQLException {
        if (this.con != null) {
            this.con.commit();
        }
    }

    public void rollback() {
        if (this.con != null) {
            try {
                this.con.rollback();
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        block13: {
            block14: {
                ps = null;
                try {
                    try {
                        ps = this.con.prepareStatement("shutdown;");
                        ps.execute();
                    }
                    catch (SQLException e) {
                        DBConnection.logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                catch (Throwable var4_4) {
                    var3_5 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e) {
                            DBConnection.logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        ps = null;
                    }
                    throw var4_4;
                }
                {
                    var3_6 = null;
                    if (ps == null) break block13;
                }
                ** try [egrp 2[TRYBLOCK] [3 : 54->63)] { 
lbl26:
                // 1 sources

                ps.close();
                break block14;
lbl28:
                // 1 sources

                catch (SQLException e) {
                    DBConnection.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            ps = null;
        }
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException e) {
                DBConnection.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.con = null;
        }
    }

    public Connection getConnection() {
        return this.con;
    }

    protected void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }
}

