/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.dao;

import java.util.ArrayList;
import jp.valtech.bts.connection.DBConnection;
import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.dao.DataBaseAccessor;
import jp.valtech.bts.data.Attachment;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class AttachmentDAO
extends DataBaseAccessor {
    private static final String CREATE_TABLE = "CREATE TABLE ATTACHMENT( FINGERPRINT  VARCHAR(40), TYPE         CHAR(1), DISPLAYNAME  VARCHAR(40), REALPATH     VARCHAR(300)) ;CREATE INDEX IDX_ATTACHMENT ON ATTACHMENT(FINGERPRINT) ;";
    private static final String DROP_TABLE = "DROP TABLE ATTACHMENT CASCADE";
    private static final String INSERT_SQL = "INSERT INTO ATTACHMENT( FINGERPRINT, TYPE, DISPLAYNAME, REALPATH ) VALUES(?, ?, ?, ?)";
    private static final String DELETE_SQL = "DELETE FROM ATTACHMENT WHERE REALPATH=?";
    private static final String DELETE_BY_FINGERPRINT = "DELETE FROM ATTACHMENT WHERE FINGERPRINT=? AND TYPE=?";
    private static final String UPDATE_GARBAGE = "UPDATE ATTACHMENT SET TYPE='G' WHERE FINGERPRINT=? AND TYPE='R'";
    private static final String REPLACE_ISSUE_TYPE = "UPDATE ATTACHMENT SET TYPE='R' WHERE FINGERPRINT=? AND TYPE='D'";
    private static final String SELECT_ALL = "SELECT FINGERPRINT, TYPE, DISPLAYNAME, REALPATH FROM ATTACHMENT";
    private static final String SELECT_BY_FINGERPRINT = "SELECT FINGERPRINT, TYPE, DISPLAYNAME, REALPATH FROM ATTACHMENT WHERE FINGERPRINT=? AND TYPE=? ";
    static /* synthetic */ Class class$0;

    public AttachmentDAO(DBConnection connection) {
        super(connection);
    }

    public void createTable() throws BtsDBException {
        try {
            new QueryRunner().update(this.con, CREATE_TABLE);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void dropTable() throws BtsDBException {
        try {
            new QueryRunner().update(this.con, DROP_TABLE);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void addAttachment(Attachment attachment) throws BtsDBException {
        try {
            ArrayList<String> param = new ArrayList<String>();
            param.add(attachment.getFingerPrint());
            param.add(attachment.getType());
            param.add(attachment.getDisplayName());
            param.add(attachment.getRealPath());
            new QueryRunner().update(this.con, INSERT_SQL, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void delete(Attachment attachment) throws BtsDBException {
        try {
            new QueryRunner().update(this.con, DELETE_SQL, (Object)attachment.getRealPath());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void deleteByFingerPrint(String fingerPrint, String type) throws BtsDBException {
        try {
            ArrayList<String> param = new ArrayList<String>();
            param.add(fingerPrint);
            param.add(type);
            new QueryRunner().update(this.con, DELETE_BY_FINGERPRINT, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public int replaceReleaseVersion(String fingerPrint) throws BtsDBException {
        try {
            return new QueryRunner().update(this.con, REPLACE_ISSUE_TYPE, (Object)fingerPrint);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public ArrayList getByFingerPrint(String fingerPrint, String type) throws BtsDBException {
        try {
            ArrayList<String> param = new ArrayList<String>();
            param.add(fingerPrint);
            param.add(type);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.valtech.bts.data.Attachment");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BeanListHandler rsh = new BeanListHandler((Class)clazz);
            return (ArrayList)new QueryRunner().query(this.con, SELECT_BY_FINGERPRINT, param.toArray(), (ResultSetHandler)rsh);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void changeGarbageVersion(String fingerPrint) throws BtsDBException {
        try {
            ArrayList<String> param = new ArrayList<String>();
            param.add(fingerPrint);
            new QueryRunner().update(this.con, UPDATE_GARBAGE, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }
}

