/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.dao;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import jp.valtech.bts.connection.DBConnection;
import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.dao.DataBaseAccessor;
import jp.valtech.bts.data.IssueHistory;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class IssueHistoryDAO
extends DataBaseAccessor {
    private static final String CREATE_TABLE = "CREATE TABLE ISSUEHISTORY ( FINGERPRINT     VARCHAR(30) , TYPE            CHAR(1)  , UPDATEATTRIBUTE LONGVARCHAR , UPDATEBEFORE    LONGVARCHAR , UPDATEAFTER     LONGVARCHAR , UPDATEUSER      VARCHAR(30)  , UPDATEDATE      TIMESTAMP ) ;CREATE INDEX IDX_HISTORY ON ISSUEHISTORY(FINGERPRINT) ;";
    private static final String DROP_TABLE = "DROP TABLE ISSUEHISTORY CASCADE;";
    private static final String INSERT_SQL = "INSERT INTO ISSUEHISTORY ( FINGERPRINT , TYPE , UPDATEATTRIBUTE , UPDATEBEFORE , UPDATEAFTER , UPDATEUSER , UPDATEDATE )  VALUES(?, ?, ?, ?, ?, ?, ?)";
    private static final String DELETE_SQL = "DELETE FROM ISSUEHISTORY WHERE FINGERPRINT=? AND TYPE=?";
    private static final String SELECT_BY_FINGERPRINT = "SELECT   FINGERPRINT , TYPE , UPDATEATTRIBUTE , UPDATEBEFORE , UPDATEAFTER , UPDATEUSER , UPDATEDATE FROM  ISSUEHISTORY WHERE FINGERPRINT=? AND TYPE=? ORDER BY UPDATEDATE DESC";
    private static final String SELECT_MOVED_GARBAGE = "SELECT   FINGERPRINT , TYPE , UPDATEATTRIBUTE , UPDATEBEFORE , UPDATEAFTER , UPDATEUSER , UPDATEDATE FROM  ISSUEHISTORY WHERE FINGERPRINT=? AND UPDATEATTRIBUTE=?";
    private static final String UPDATE_GARBAGE = "UPDATE ISSUEHISTORY SET TYPE='G' WHERE FINGERPRINT=? AND TYPE='R'";
    static /* synthetic */ Class class$0;

    public IssueHistoryDAO(DBConnection connection) {
        super(connection);
    }

    public void createTable() throws BtsDBException {
        try {
            new QueryRunner().update(this.con, CREATE_TABLE);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void dropTable() throws BtsDBException {
        try {
            new QueryRunner().update(this.con, DROP_TABLE);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void addHistory(IssueHistory issueHistory) throws BtsDBException {
        try {
            ArrayList<Object> param = new ArrayList<Object>();
            param.add(issueHistory.getFingerPrint());
            param.add(issueHistory.getType());
            param.add(issueHistory.getUpdateAttribute());
            param.add(issueHistory.getUpdateBefore());
            param.add(issueHistory.getUpdateAfter());
            param.add(issueHistory.getUpdateUser());
            if (issueHistory.getUpdateDate() != null) {
                param.add(new Timestamp(issueHistory.getUpdateDate().getTime()));
            } else {
                param.add(null);
            }
            new QueryRunner().update(this.con, INSERT_SQL, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void deleteByFingerPrint(String fingerprint, String type) throws BtsDBException {
        try {
            ArrayList<String> param = new ArrayList<String>();
            param.add(fingerprint);
            param.add(type);
            new QueryRunner().update(this.con, DELETE_SQL, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public IssueHistory[] getByFingerPrint(String fingerprint, String type) throws BtsDBException {
        IssueHistory[] issueHistories = new IssueHistory[]{};
        try {
            ArrayList<String> param = new ArrayList<String>();
            param.add(fingerprint);
            param.add(type);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.valtech.bts.data.IssueHistory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BeanListHandler rsh = new BeanListHandler((Class)clazz);
            List result = (List)new QueryRunner().query(this.con, SELECT_BY_FINGERPRINT, param.toArray(), (ResultSetHandler)rsh);
            issueHistories = result.toArray(issueHistories);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
        return issueHistories;
    }

    public IssueHistory getMovedGarbageHistory(String fingerPrint) throws BtsDBException {
        try {
            ArrayList<String> param = new ArrayList<String>();
            param.add(fingerPrint);
            param.add(IssueHistory.ISSUE_MOVE_GARBAGE);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.valtech.bts.data.IssueHistory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BeanHandler rsh = new BeanHandler((Class)clazz);
            return (IssueHistory)new QueryRunner().query(this.con, SELECT_MOVED_GARBAGE, param.toArray(), (ResultSetHandler)rsh);
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }

    public void changeGarbageVersion(String fingerPrint) throws BtsDBException {
        try {
            ArrayList<String> param = new ArrayList<String>();
            param.add(fingerPrint);
            new QueryRunner().update(this.con, UPDATE_GARBAGE, param.toArray());
        }
        catch (Exception e) {
            throw new BtsDBException(e);
        }
    }
}

