/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.facade;

import java.util.ArrayList;
import jp.valtech.bts.connection.IssueDBConnection;
import jp.valtech.bts.dao.AttachmentDAO;
import jp.valtech.bts.data.Attachment;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.util.AttachmentUtility;
import jp.valtech.bts.util.Logging;

public class AttachmentFacade
implements Logging {
    public static void add(Issue issue, IssueDBConnection dbcon) throws Exception {
        AttachmentUtility utility = new AttachmentUtility();
        Attachment[] addList = utility.writeWorkspaceFromLocal(issue.getAttachments());
        if (addList == null || addList.length == 0) {
            return;
        }
        AttachmentDAO attachmentDAO = new AttachmentDAO(dbcon);
        int i = 0;
        while (i < addList.length) {
            logger.debug((Object)("AddAttachment:" + addList[i].getDisplayName()));
            attachmentDAO.addAttachment(addList[i]);
            ++i;
        }
    }

    public static void delete(Attachment[] deleteList, IssueDBConnection dbcon) throws Exception {
        if (deleteList == null || deleteList.length == 0) {
            return;
        }
        AttachmentUtility utility = new AttachmentUtility();
        utility.delete(deleteList);
        AttachmentDAO attachmentDAO = new AttachmentDAO(dbcon);
        int i = 0;
        while (i < deleteList.length) {
            logger.debug((Object)("DeleteAttachment:" + deleteList[i].getDisplayName()));
            attachmentDAO.delete(deleteList[i]);
            ++i;
        }
    }

    public static void deleteAll(Issue issue, String type, IssueDBConnection dbcon) throws Exception {
        AttachmentFacade.deleteAll(issue.getFingerPrint(), type, dbcon);
    }

    public static void deleteAll(String fingerPrint, String type, IssueDBConnection dbcon) throws Exception {
        AttachmentDAO attachmentDAO = new AttachmentDAO(dbcon);
        ArrayList deleteList = attachmentDAO.getByFingerPrint(fingerPrint, type);
        if (deleteList == null || deleteList.size() == 0) {
            return;
        }
        Attachment[] deleteAttachments = deleteList.toArray(new Attachment[0]);
        AttachmentUtility utility = new AttachmentUtility();
        utility.delete(deleteAttachments);
        if (logger.isDebugEnabled()) {
            int i = 0;
            while (i < deleteAttachments.length) {
                logger.debug((Object)("DeleteAllAttachment:" + deleteAttachments[i].getDisplayName()));
                ++i;
            }
        }
        attachmentDAO.deleteByFingerPrint(fingerPrint, type);
    }

    public static void clone(Issue issue, IssueDBConnection dbcon) throws Exception {
        AttachmentUtility utility = new AttachmentUtility();
        Attachment[] cloneList = utility.clone(issue.getAttachments());
        if (cloneList == null || cloneList.length == 0) {
            return;
        }
        AttachmentDAO attachmentDAO = new AttachmentDAO(dbcon);
        int i = 0;
        while (i < cloneList.length) {
            logger.debug((Object)("CloneAttachment:" + cloneList[i].getDisplayName()));
            attachmentDAO.addAttachment(cloneList[i]);
            ++i;
        }
    }

    public static void addFromEntity(Issue issue, IssueDBConnection dbcon) throws Exception {
        Attachment[] attachments = issue.getAttachments();
        if (attachments == null) {
            return;
        }
        AttachmentUtility utility = new AttachmentUtility();
        utility.writeWorkspaceFromEntity(attachments);
        AttachmentDAO attachmentDAO = new AttachmentDAO(dbcon);
        int i = 0;
        while (i < attachments.length) {
            logger.debug((Object)("AddAttachment:" + attachments[i].getDisplayName()));
            attachmentDAO.addAttachment(attachments[i]);
            ++i;
        }
    }

    public static void replaceReleaseVersion(Issue issue, IssueDBConnection dbcon) throws Exception {
        AttachmentFacade.deleteAll(issue, "R", dbcon);
        AttachmentDAO attachmentDAO = new AttachmentDAO(dbcon);
        attachmentDAO.replaceReleaseVersion(issue.getFingerPrint());
    }
}

