/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.facade;

import jp.valtech.bts.connection.IssueDBConnection;
import jp.valtech.bts.dao.IssueHistoryDAO;
import jp.valtech.bts.data.IssueHistory;
import jp.valtech.bts.facade.Messages;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.util.Logging;

public class IssueHistoryFacade
implements Logging {
    IssueDBConnection dbcon = new IssueDBConnection();

    public IssueHistory[] getByFingerPrint(String fingerprint, String type) {
        try {
            IssueHistoryDAO dao = new IssueHistoryDAO(this.dbcon);
            return dao.getByFingerPrint(fingerprint, type);
        }
        catch (Exception e) {
            String msg = Messages.getString("IssueHistoryFacade.0");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
            return null;
        }
    }

    public void close() {
        this.dbcon.close();
        this.dbcon = null;
    }
}

