/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.network;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.preference.BtsPreference;

public class ClientList {
    private static Map clients = null;
    private static ClientList clientList = null;

    private ClientList() {
    }

    public static synchronized ClientList getInstance() {
        if (clientList == null) {
            clientList = new ClientList();
        }
        return clientList;
    }

    public static synchronized void add(InetAddress ipAddress, String clientName, int port) {
        ClientInfo clientInfo = new ClientInfo();
        clientInfo.setClientAddress(ipAddress.getHostAddress());
        clientInfo.setClientHostName(ipAddress.getHostName());
        clientInfo.setClientName(clientName);
        clientInfo.setPort(new Integer(port));
        ClientList.add(clientInfo);
    }

    public static synchronized void add(ClientInfo clientInfo) {
        if (clients == null) {
            clients = Collections.synchronizedMap(new TreeMap());
        }
        clients.put(clientInfo.getClientAddress(), clientInfo);
    }

    public static synchronized void addMyInfo() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String userName = CurrentProject.getInsance().getProjectConfig().getUserName();
            int tcpPort = BtsPreference.getInstance().getTCPPort();
            ClientList.add(inetAddress, userName, tcpPort);
        }
        catch (Exception e) {
            BtsPlugin.getInstance().errorlog(e);
        }
    }

    public static synchronized String getClientName(InetAddress ipAddress) {
        return ClientList.getClientName(ipAddress.getHostAddress());
    }

    public static synchronized String getClientName(String ipAddress) {
        ClientInfo clientInfo = ClientList.getClientInfo(ipAddress);
        String result = null;
        if (clientInfo != null) {
            result = clientInfo.getClientName();
        }
        return result;
    }

    public static ClientInfo[] getClientInfoList() {
        Collection col = clients.values();
        return col.toArray(new ClientInfo[0]);
    }

    public static synchronized int getPort(String ipAddress) {
        ClientInfo clientInfo = ClientList.getClientInfo(ipAddress);
        int result = -1;
        if (clientInfo != null) {
            result = clientInfo.getPort();
        }
        return result;
    }

    public static synchronized ClientInfo getClientInfo(String ipAddress) {
        ClientInfo clientInfo = null;
        if (clients != null && clients.containsKey(ipAddress)) {
            clientInfo = (ClientInfo)clients.get(ipAddress);
        }
        return clientInfo;
    }

    public static ClientInfo getClientInfoByClientName(String userName) {
        Collection col = clients.values();
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            ClientInfo info = (ClientInfo)iterator.next();
            if (!userName.equals(info.getClientName())) continue;
            return info;
        }
        return null;
    }

    public static synchronized ClientInfo getClientInfo(InetAddress inetAddress) {
        return ClientList.getClientInfo(inetAddress.getHostAddress());
    }

    public static synchronized ClientInfo getMyInfo() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return ClientList.getClientInfo(inetAddress.getHostAddress());
        }
        catch (Exception e) {
            BtsPlugin.getInstance().errorlog(e);
            return null;
        }
    }

    public static synchronized void remove(InetAddress ipAddress) {
        if (clients != null) {
            clients.remove(ipAddress.getHostAddress());
        }
    }

    public static synchronized String[] addresses() {
        String[] result = new String[]{};
        if (clients != null) {
            result = clients.keySet().toArray(result);
        }
        return result;
    }

    public static synchronized void clear() {
        if (clients != null) {
            clients.clear();
            clients = null;
        }
    }
}

