/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import java.util.List;
import jp.valtech.bts.command.client.Leave;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.ClientList;
import jp.valtech.bts.network.server.Server;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.ui.msglist.MessageListView;
import jp.valtech.bts.ui.navigator.TreeHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;

public class CloseProjectAction
extends Action {
    private String ssid;

    public CloseProjectAction() {
        this.setText(Messages.getString("CloseProjectAction.0"));
        this.setToolTipText(Messages.getString("CloseProjectAction.1"));
        this.setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("project_close.gif"));
    }

    public void run() {
        Server server = Server.getServer();
        server.stopServer();
        Leave leave = new Leave(new NetworkConfig());
        leave.execute();
        ClientList.clear();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TreeHelper.closeProjectNode(CloseProjectAction.this.ssid);
            }
        });
        List listeners = BtsPlugin.getInstance().getListeners();
        int idx = 0;
        while (idx < listeners.size()) {
            IBtsListener listnener = (IBtsListener)listeners.get(idx);
            listnener.clear();
            ++idx;
        }
        BtsPlugin plugin = BtsPlugin.getInstance();
        MessageListView messageListView = plugin.getMessageView();
        if (messageListView != null) {
            messageListView.getMsgTxt().setText("");
        }
        BtsPlugin.getInstance().closeAllIssueEditors();
        CurrentProject current = CurrentProject.getInsance();
        current.close();
    }

    public void setSSID(String ssid) {
        this.ssid = ssid;
    }
}

