/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import java.util.List;
import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.facade.ModifyIssueFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.ui.navigator.IssueChartDialog;
import jp.valtech.bts.util.IssueChartRender;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class OpenChartDlgAction
extends Action {
    private static final ImageDescriptor THIS_IMAGE = BtsPlugin.getInstance().getImageDescriptor("chart.gif");
    private static final ImageDescriptor THIS_IMAGE_DISABLE = BtsPlugin.getInstance().getImageDescriptor("chart_disable.gif");
    private ViewPart view;

    public OpenChartDlgAction(ViewPart view) {
        this.view = view;
        this.setText(Messages.getString("OpenChartDlgAction.0"));
        this.setToolTipText(Messages.getString("OpenChartDlgAction.1"));
        this.setImageDescriptor(THIS_IMAGE);
        this.setDisabledImageDescriptor(THIS_IMAGE_DISABLE);
    }

    public void run() {
        List chartIssueList;
        ModifyIssueFacade issueModifyFacade = new ModifyIssueFacade();
        try {
            chartIssueList = issueModifyFacade.getByType("R");
        }
        catch (BtsDBException btsDBException) {
            MessageDialog.openError((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("OpenChartDlgAction.2"), (String)Messages.getString("OpenChartDlgAction.3"));
            return;
        }
        if (chartIssueList.size() == 0) {
            MessageDialog.openError((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("OpenChartDlgAction.4"), (String)Messages.getString("OpenChartDlgAction.5"));
            return;
        }
        IssueChartRender render = new IssueChartRender(chartIssueList);
        render.createChart();
        IssueChartDialog issueChartDialog = new IssueChartDialog(this.view.getSite().getShell(), chartIssueList);
        issueChartDialog.open();
    }
}

