/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import java.util.ArrayList;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.facade.ModifyIssueFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.ui.editor.IssueMultiPageEditorInput;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;

public class OpenIssueAction
extends Action
implements Logging {
    private static final ImageDescriptor EXIST_ISSUE = BtsPlugin.getInstance().getImageDescriptor("issue.gif");
    private static final ImageDescriptor NEW_ISSUE = BtsPlugin.getInstance().getImageDescriptor("issue_new.gif");
    private static final ImageDescriptor NEW_ISSUE_DISABLE = BtsPlugin.getInstance().getImageDescriptor("issue_new_disable.gif");
    public static final int OPEN_NEW_ISSUE = 0;
    public static final int OPEN_EXIST_ISSUE = 1;
    public static final int OPEN_CATEGORY_ISSUE = 2;
    private int mode = 0;
    private String category = "";
    private String fingerPrint = "";
    private String type = "";

    public OpenIssueAction() {
        this(0);
    }

    public OpenIssueAction(int mode) {
        this.mode = mode;
        if (mode == 0) {
            this.setText(Messages.getString("OpenIssueAction.0"));
            this.setToolTipText(Messages.getString("OpenIssueAction.1"));
            this.setImageDescriptor(NEW_ISSUE);
            this.setDisabledImageDescriptor(NEW_ISSUE_DISABLE);
        } else if (mode == 1) {
            this.setText(Messages.getString("OpenIssueAction.2"));
            this.setToolTipText(Messages.getString("OpenIssueAction.3"));
            this.setImageDescriptor(EXIST_ISSUE);
        } else if (mode == 2) {
            this.setText(Messages.getString("OpenIssueAction.4"));
            this.setToolTipText(Messages.getString("OpenIssueAction.5"));
            this.setImageDescriptor(NEW_ISSUE);
        }
    }

    public void run() {
        try {
            IssueMultiPageEditorInput input = new IssueMultiPageEditorInput();
            if (this.mode == 0) {
                Issue openIssue = new Issue();
                openIssue.setVersion(0);
                openIssue.setType("D");
                openIssue.setStatus("1");
                openIssue.setAttachmentList(new ArrayList());
                input.setIssue(openIssue);
                input.setOpenMode(0);
            } else if (this.mode == 1) {
                ModifyIssueFacade issueModifyFacade = new ModifyIssueFacade();
                Issue openIssue = issueModifyFacade.getByFingerPrint(this.fingerPrint, this.type);
                if (openIssue == null) {
                    MessageDialog.openInformation((Shell)BtsPlugin.getInstance().getShell(), (String)"Infomation", (String)(String.valueOf(Messages.getString("OpenIssueAction.6")) + Messages.getString("OpenIssueAction.7") + Messages.getString("OpenIssueAction.8")));
                    return;
                }
                input.setIssue(openIssue);
                input.setOpenMode(1);
            } else if (this.mode == 2) {
                Issue openIssue = new Issue();
                openIssue.setVersion(0);
                openIssue.setType("D");
                openIssue.setStatus("1");
                openIssue.setCategory(this.category);
                openIssue.setAttachmentList(new ArrayList());
                input.setIssue(openIssue);
                input.setOpenMode(0);
            }
            BtsPlugin.getInstance().openEditor(input, true);
        }
        catch (Exception e) {
            String msg = Messages.getString("OpenIssueAction.9");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setIssue(Issue issue) {
        this.fingerPrint = issue.getFingerPrint();
        this.type = issue.getType();
    }

    public void setIssueKeys(String fingerPrint, String type) {
        this.fingerPrint = fingerPrint;
        this.type = type;
    }
}

