/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.network.server.Server;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.ui.action.RefreshAction;
import jp.valtech.bts.ui.action.SyncRemoteAction;
import jp.valtech.bts.ui.action.SyncSelectionRemoteAction;
import jp.valtech.bts.ui.issuelist.IssueListView;
import jp.valtech.bts.ui.issuelist.IssueListViewFilter;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.ui.navigator.TreeHelper;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class OpenProjectAction
extends Action
implements Logging {
    private String ssid = "";

    public OpenProjectAction() {
        this.setText(Messages.getString("OpenProjectAction.0"));
        this.setToolTipText(Messages.getString("OpenProjectAction.1"));
        this.setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("project.gif"));
    }

    public void setSSID(String ssid) {
        this.ssid = ssid;
    }

    public void run() {
        try {
            IssueListView view;
            CurrentProject current = CurrentProject.getInsance();
            if (current.isOpen()) {
                MessageDialog.openInformation((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("OpenProjectAction.2"), (String)Messages.getString("OpenProjectAction.3"));
                return;
            }
            current.setCurrentProject(this.ssid);
            Server server = Server.getServer();
            server.startServer();
            boolean isSyncFinished = false;
            ProjectConfig prjctConf = CurrentProject.getInsance().getProjectConfig();
            if (prjctConf.isAutoSyncCheck()) {
                Action syncAction;
                if (prjctConf.isNormalSyncRadio()) {
                    syncAction = new SyncRemoteAction();
                    syncAction.run();
                    isSyncFinished = syncAction.isFinished();
                } else if (prjctConf.isAppointSyncRadio()) {
                    syncAction = new SyncSelectionRemoteAction();
                    syncAction.run();
                    isSyncFinished = syncAction.isFinished();
                }
            }
            if (!isSyncFinished) {
                RefreshAction refresh = new RefreshAction();
                refresh.run();
            }
            if ((view = BtsPlugin.getInstance().getIssueView()) != null) {
                IssueListViewFilter filter = new IssueListViewFilter(view);
                filter.setClearFilter();
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    TreeHelper.openProjectNode(OpenProjectAction.this.ssid);
                }
            });
        }
        catch (Exception e) {
            String msg = Messages.getString("OpenProjectAction.4");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }
}

