/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import java.util.List;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.facade.ModifyIssueFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.action.Action;

public class RefreshAction
extends Action
implements Logging {
    public RefreshAction() {
        this.setText(Messages.getString("RefreshAction.0"));
        this.setToolTipText(Messages.getString("RefreshAction.1"));
        this.setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("refresh.gif"));
    }

    public void run() {
        try {
            CurrentProject project = CurrentProject.getInsance();
            if (!project.isOpen()) {
                return;
            }
            ModifyIssueFacade issueModifyFacade = new ModifyIssueFacade();
            List issueList = issueModifyFacade.getIssueList();
            List listeners = BtsPlugin.getInstance().getListeners();
            int idx = 0;
            while (idx < listeners.size()) {
                IBtsListener listnener = (IBtsListener)listeners.get(idx);
                listnener.refresh(issueList);
                ++idx;
            }
        }
        catch (Exception e) {
            String msg = Messages.getString("RefreshAction.2");
            BtsPlugin.getInstance().error(msg, e);
            logger.fatal((Object)msg, (Throwable)e);
        }
    }
}

