/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import java.util.ArrayList;
import java.util.List;
import jp.valtech.bts.data.Attachment;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.facade.ModifyIssueFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.ui.editor.IssueMultiPageEditor;
import jp.valtech.bts.ui.editor.IssueMultiPageEditorInput;
import jp.valtech.bts.util.IssueUtility;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;

public class SaveIssueAction
extends Action
implements Logging {
    private static final ImageDescriptor THIS_IMAGE = BtsPlugin.getInstance().getImageDescriptor("save.gif");
    private static final ImageDescriptor THIS_IMAGE_DISABLE = BtsPlugin.getInstance().getImageDescriptor("save_disable.gif");

    public SaveIssueAction() {
        this.setText(Messages.getString("SaveIssueAction.0"));
        this.setToolTipText(Messages.getString("SaveIssueAction.1"));
        this.setImageDescriptor(THIS_IMAGE);
        this.setDisabledImageDescriptor(THIS_IMAGE_DISABLE);
    }

    public void run() {
        IssueMultiPageEditor editorPart = BtsPlugin.getInstance().getActiveEditor();
        if (editorPart == null) {
            logger.debug((Object)Messages.getString("SaveIssueAction.2"));
            return;
        }
        try {
            IssueMultiPageEditorInput issueEditorInput = (IssueMultiPageEditorInput)editorPart.getEditorInput();
            Issue newIssue = editorPart.getModifiedIssue();
            if (newIssue == null) {
                return;
            }
            String typeUpdateBefore = newIssue.getType();
            this.updateIssueInfo(newIssue);
            ArrayList oldAttachList = issueEditorInput.getSavedAttachment();
            ArrayList newAttachList = newIssue.getAttachmentList();
            Attachment[] deleteList = IssueUtility.getAttachmentDeleteList(oldAttachList, newAttachList);
            ModifyIssueFacade issueModifyFacade = new ModifyIssueFacade();
            Issue registedDraftIssue = issueModifyFacade.getByFingerPrint(newIssue.getFingerPrint(), "D");
            if (registedDraftIssue == null) {
                if (typeUpdateBefore.equals("R")) {
                    issueModifyFacade.addCloneIssue(newIssue);
                } else {
                    issueModifyFacade.addNewDraftIssue(newIssue);
                }
                List listeners = BtsPlugin.getInstance().getListeners();
                int idx = 0;
                while (idx < listeners.size()) {
                    IBtsListener listnener = (IBtsListener)listeners.get(idx);
                    listnener.addIssue(newIssue);
                    ++idx;
                }
                MessageDialog.openInformation((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("SaveIssueAction.3"), (String)Messages.getString("SaveIssueAction.4"));
            } else if ("D".equals(typeUpdateBefore)) {
                issueModifyFacade.updateIssue(newIssue, deleteList);
                Issue oldIssue = issueEditorInput.getIssue();
                List listeners = BtsPlugin.getInstance().getListeners();
                int idx = 0;
                while (idx < listeners.size()) {
                    IBtsListener listnener = (IBtsListener)listeners.get(idx);
                    listnener.updateIssue(oldIssue, newIssue);
                    ++idx;
                }
            } else if ("R".equals(typeUpdateBefore)) {
                issueModifyFacade.replaceIssue(newIssue, deleteList);
                List listeners = BtsPlugin.getInstance().getListeners();
                int idx = 0;
                while (idx < listeners.size()) {
                    IBtsListener listnener = (IBtsListener)listeners.get(idx);
                    listnener.updateIssue(registedDraftIssue, newIssue);
                    ++idx;
                }
                this.closeIssueEditor(newIssue);
            }
            editorPart.postIssueSave(newIssue);
        }
        catch (Exception e) {
            String msg = Messages.getString("SaveIssueAction.5");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }

    private void updateIssueInfo(Issue newIssue) {
        newIssue.setType("D");
        Attachment[] attachments = newIssue.getAttachments();
        if (attachments == null) {
            return;
        }
        int i = 0;
        while (i < attachments.length) {
            attachments[i].setFingerPrint(newIssue.getFingerPrint());
            attachments[i].setType("D");
            ++i;
        }
    }

    private void closeIssueEditor(Issue issue) {
        if ("D".equals(issue.getType())) {
            BtsPlugin.getInstance().closeIssueEditor(issue.getFingerPrint(), "D");
        }
    }
}

