/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import java.util.ArrayList;
import java.util.List;
import jp.valtech.bts.data.Attachment;
import jp.valtech.bts.data.CommentHistory;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueHistory;
import jp.valtech.bts.data.Vote;
import jp.valtech.bts.facade.ModifyIssueFacade;
import jp.valtech.bts.facade.SendIssueFacade;
import jp.valtech.bts.facade.VoteDAOFacade;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.ui.BtsException;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.ui.action.SendIssueAction;
import jp.valtech.bts.ui.editor.IssueMultiPageEditor;
import jp.valtech.bts.ui.editor.IssueMultiPageEditorInput;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.util.AttachmentUtility;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.IssueUtility;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class SendReleaseIssueAction
extends SendIssueAction {
    private Issue latestIssue;
    private IssueHistory[] sendHistory;
    private CommentHistory[] sendComment;
    private IssueMultiPageEditor editorPart = null;

    public SendReleaseIssueAction() {
        this.setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("send.gif"));
        this.setText(Messages.getString("SendReleaseIssueAction.0"));
        this.setToolTipText(Messages.getString("SendReleaseIssueAction.1"));
    }

    public void run() {
        try {
            super.run();
            this.editorPart = BtsPlugin.getInstance().getActiveEditor();
            if (this.editorPart == null) {
                logger.debug((Object)Messages.getString("SendReleaseIssueAction.2"));
                return;
            }
            Issue newIssue = this.editorPart.getModifiedIssue();
            if (newIssue == null) {
                return;
            }
            IssueMultiPageEditorInput issueEditorInput = (IssueMultiPageEditorInput)this.editorPart.getEditorInput();
            MessageDialog dialog = new MessageDialog(BtsPlugin.getInstance().getShell(), Messages.getString("SendReleaseIssueAction.3"), null, String.valueOf(Messages.getString("SendReleaseIssueAction.4")) + newIssue.getTitle() + Messages.getString("SendReleaseIssueAction.5"), 3, new String[]{Messages.getString("SendReleaseIssueAction.6"), Messages.getString("SendReleaseIssueAction.7")}, 1);
            int res = dialog.open();
            if (res != 0) {
                return;
            }
            boolean verchk = this.checkVersion(newIssue);
            if (!verchk) {
                return;
            }
            this.closeIssueEditor(newIssue);
            this.saveIssue(newIssue, issueEditorInput);
            this.editorPart.postIssueSave(newIssue);
            this.editorPart.postCommentHistorySave(this.sendComment);
            this.editorPart.postIssueHistorySave(this.sendHistory);
            AttachmentUtility utility = new AttachmentUtility();
            utility.read(newIssue.getAttachments());
            VoteDAOFacade facade = new VoteDAOFacade();
            Vote[] votes = facade.get(newIssue.getFingerPrint());
            newIssue.setIssueHistories(this.sendHistory);
            newIssue.setCommentHistories(this.sendComment);
            newIssue.setVotes(votes);
            this.sendIssue(newIssue);
            this.saveMessage(newIssue, "R");
        }
        catch (Exception e) {
            String msg = Messages.getString("SendReleaseIssueAction.8");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }

    private CommentHistory getNewComment(Issue newIssue) {
        String newComment = this.editorPart.getNewComment();
        if (newComment == null || newComment.trim().equals("")) {
            return null;
        }
        CommentHistory commentHistory = new CommentHistory();
        commentHistory.setDescription(newComment);
        commentHistory.setFingerPrint(newIssue.getFingerPrint());
        commentHistory.setType("R");
        commentHistory.setUpdateDate(System.currentTimeMillis());
        ProjectConfig config = CurrentProject.getInsance().getProjectConfig();
        commentHistory.setUpdateUser(config.getUserName());
        return commentHistory;
    }

    private void closeIssueEditor(Issue issue) {
        if ("D".equals(issue.getType())) {
            BtsPlugin.getInstance().closeIssueEditor(issue.getFingerPrint(), "R");
        }
    }

    private boolean checkVersion(Issue oldIssue) {
        int myVer = oldIssue.getVersion();
        if (myVer == 0) {
            return true;
        }
        ModifyIssueFacade facade = new ModifyIssueFacade();
        this.latestIssue = facade.getByFingerPrint(oldIssue.getFingerPrint(), "R");
        if (this.latestIssue == null) {
            return true;
        }
        int latestVer = this.latestIssue.getVersion();
        if (latestVer != myVer) {
            MessageDialog.openWarning((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("SendReleaseIssueAction.9"), (String)(String.valueOf(Messages.getString("SendReleaseIssueAction.10")) + Messages.getString("SendReleaseIssueAction.11") + Messages.getString("SendReleaseIssueAction.12")));
            return false;
        }
        return true;
    }

    private void saveIssue(Issue newIssue, IssueMultiPageEditorInput issueEditorInput) throws BtsException {
        String typeUpdateBefore = newIssue.getType();
        newIssue.setType("R");
        if (newIssue.getVersion() == 0) {
            newIssue.setCreateUser(CurrentProject.getInsance().getProjectConfig().getUserName());
            newIssue.setCreateDate(System.currentTimeMillis());
        }
        newIssue.setUpdateDate(System.currentTimeMillis());
        newIssue.setVersion(newIssue.getVersion() + 1);
        Attachment[] attachments = newIssue.getAttachments();
        if (attachments != null) {
            int i = 0;
            while (i < attachments.length) {
                attachments[i].setFingerPrint(newIssue.getFingerPrint());
                attachments[i].setType("R");
                ++i;
            }
        }
        Issue oldIssue = issueEditorInput.getIssue();
        CommentHistory newComment = this.getNewComment(newIssue);
        IssueHistory[] histories = this.getIssueHistory(newIssue, newComment, issueEditorInput);
        int mode = issueEditorInput.getOpenMode();
        ArrayList oldAttachList = issueEditorInput.getSavedAttachment();
        ArrayList newAttachList = newIssue.getAttachmentList();
        Attachment[] deleteList = IssueUtility.getAttachmentDeleteList(oldAttachList, newAttachList);
        SendIssueFacade facade = new SendIssueFacade();
        if (mode == 0) {
            facade.addIssue(newIssue, histories, newComment);
            List listeners = BtsPlugin.getInstance().getListeners();
            int idx = 0;
            while (idx < listeners.size()) {
                IBtsListener listnener = (IBtsListener)listeners.get(idx);
                listnener.addIssue(newIssue);
                ++idx;
            }
        } else if (mode == 1) {
            if ("R".equals(typeUpdateBefore)) {
                facade.updateVersion(newIssue, histories, deleteList, newComment);
                List listeners = BtsPlugin.getInstance().getListeners();
                int idx = 0;
                while (idx < listeners.size()) {
                    IBtsListener listnener = (IBtsListener)listeners.get(idx);
                    listnener.updateIssue(oldIssue, newIssue);
                    ++idx;
                }
            } else if ("D".equals(typeUpdateBefore)) {
                Issue beforeUpdateReleaseIssue = facade.updateRelease(newIssue, histories, deleteList, newComment);
                List listeners = BtsPlugin.getInstance().getListeners();
                int idx = 0;
                while (idx < listeners.size()) {
                    IBtsListener listnener = (IBtsListener)listeners.get(idx);
                    listnener.deleteIssue(oldIssue);
                    listnener.updateIssue(beforeUpdateReleaseIssue, newIssue);
                    ++idx;
                }
            }
        }
        this.sendHistory = facade.getAllHistory();
        this.sendComment = facade.getAllComment();
    }

    private IssueHistory[] getIssueHistory(Issue newIssue, CommentHistory newComment, IssueMultiPageEditorInput issueEditorInput) throws BtsException {
        Issue oldIssue = issueEditorInput.getIssue();
        IssueHistory[] histories = null;
        if (oldIssue.getVersion() == 0) {
            histories = IssueUtility.createInitialHistory(newIssue);
        } else if (oldIssue.getVersion() != 0 && "R".equals(oldIssue.getType())) {
            ArrayList savedAttachment = issueEditorInput.getSavedAttachment();
            oldIssue.setAttachmentList(savedAttachment);
            histories = IssueUtility.createIssueHistory(oldIssue, newIssue, newComment);
        } else if (oldIssue.getVersion() != 0 && "D".equals(oldIssue.getType())) {
            histories = IssueUtility.createIssueHistory(this.latestIssue, newIssue, newComment);
        }
        return histories;
    }

    protected void sendIssue(Issue issue) {
        this.sendMail(issue);
        super.sendIssue(issue);
        ReceiveUserDialog userDialog = new ReceiveUserDialog(issue.getTitle());
        userDialog.setClientInfo(this.sendUserList);
        int res = userDialog.open();
        if (res == 0) {
            BtsPlugin.getInstance().closeEditor((IEditorPart)this.editorPart, false);
        }
    }

    private class ReceiveUserDialog
    extends MessageDialog {
        private ArrayList clientList;

        public ReceiveUserDialog(String issueTitle) {
            super(BtsPlugin.getInstance().getShell(), Messages.getString("SendReleaseIssueAction.13"), null, String.valueOf(Messages.getString("SendReleaseIssueAction.14")) + issueTitle + Messages.getString("SendReleaseIssueAction.15"), 2, new String[]{Messages.getString("SendReleaseIssueAction.16"), Messages.getString("SendReleaseIssueAction.17")}, 0);
        }

        public void setClientInfo(ArrayList clientList) {
            this.clientList = clientList;
        }

        protected Control createCustomArea(Composite parent) {
            Composite thisArea = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginLeft = 40;
            thisArea.setLayout((Layout)gridLayout);
            org.eclipse.swt.widgets.List memberList = new org.eclipse.swt.widgets.List(thisArea, 2562);
            if (this.clientList == null || this.clientList.size() == 0) {
                memberList.add(Messages.getString("SendReleaseIssueAction.18"));
            } else {
                int i = 0;
                while (i < this.clientList.size()) {
                    ClientInfo clientInfo = (ClientInfo)this.clientList.get(i);
                    String userName = clientInfo.getClientName();
                    String address = BTSUtility.rightPad("(" + clientInfo.getClientAddress() + ")", 19);
                    memberList.add(String.valueOf(address) + userName);
                    ++i;
                }
            }
            GridData gridData = new GridData();
            gridData.heightHint = 60;
            gridData.widthHint = 280;
            memberList.setLayoutData((Object)gridData);
            Label label = new Label(thisArea, 16384);
            label.setText(Messages.getString("SendReleaseIssueAction.19"));
            return thisArea;
        }
    }
}

