/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import jp.valtech.bts.command.client.Ping;
import jp.valtech.bts.command.client.SyncIssue;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;

public class SyncRemoteAction
extends Action
implements Logging {
    private static final ImageDescriptor THIS_IMAGE = BtsPlugin.getInstance().getImageDescriptor("sync1.gif");
    private static final ImageDescriptor THIS_IMAGE_DISABLE = BtsPlugin.getInstance().getImageDescriptor("sync1_disable.gif");
    private boolean finished = false;

    public SyncRemoteAction() {
        this.setText(Messages.getString("SyncRemoteAction.0"));
        this.setToolTipText(Messages.getString("SyncRemoteAction.1"));
        this.setImageDescriptor(THIS_IMAGE);
        this.setDisabledImageDescriptor(THIS_IMAGE_DISABLE);
    }

    public void run() {
        ProjectConfig config = CurrentProject.getInsance().getProjectConfig();
        if (!config.isFixedSyncCheck()) {
            MessageDialog.openInformation((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("SyncRemoteAction.4"), (String)Messages.getString("SyncRemoteAction.15"));
            return;
        }
        String host = config.getSyncAddress();
        int port = config.getSyncPort();
        NetworkConfig networkConfig = new NetworkConfig();
        Ping ping = new Ping(networkConfig, host, port);
        ping.execute();
        if (!ping.isSuccessful()) {
            MessageDialog.openError((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("SyncRemoteAction.4"), (String)ping.getErrorMsg());
            return;
        }
        SyncIssue syncIssue = new SyncIssue(networkConfig, host, port);
        syncIssue.setRemoteUserName(Messages.getString("SyncRemoteAction.16"));
        syncIssue.execute();
        this.finished = syncIssue.isFinished();
    }

    public boolean isFinished() {
        return this.finished;
    }
}

