/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import jp.valtech.bts.command.client.Join;
import jp.valtech.bts.command.client.SyncIssue;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.network.ClientList;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.action.Messages;
import jp.valtech.bts.util.BTSUtility;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SyncSelectionRemoteAction
extends Action {
    private static final ImageDescriptor THIS_IMAGE = BtsPlugin.getInstance().getImageDescriptor("sync2.gif");
    private static final ImageDescriptor THIS_IMAGE_DISABLE = BtsPlugin.getInstance().getImageDescriptor("sync2_disable.gif");
    private boolean finished = false;

    public SyncSelectionRemoteAction() {
        this.setText(Messages.getString("SyncSelectionRemoteAction.0"));
        this.setToolTipText(Messages.getString("SyncSelectionRemoteAction.1"));
        this.setImageDescriptor(THIS_IMAGE);
        this.setDisabledImageDescriptor(THIS_IMAGE_DISABLE);
    }

    public void run() {
        ClientList.clear();
        ClientList.addMyInfo();
        Join join = new Join(new NetworkConfig());
        join.execute();
        if (!this.progress()) {
            return;
        }
        SyncSelectionRemoteDialog dialog = new SyncSelectionRemoteDialog(BtsPlugin.getInstance().getShell());
        dialog.open();
    }

    private boolean progress() {
        try {
            IRunnableWithProgress progress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.getString("SyncSelectionRemoteAction.3"), 100);
                    monitor.subTask(Messages.getString("SyncSelectionRemoteAction.4"));
                    int i = 0;
                    while (i < 100) {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException(Messages.getString("SyncSelectionRemoteAction.5"));
                        }
                        Thread.sleep(40L);
                        monitor.worked(1);
                        ++i;
                    }
                    monitor.done();
                }
            };
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(BtsPlugin.getInstance().getShell());
            dialog.run(true, true, progress);
            return true;
        }
        catch (InvocationTargetException e) {
            BtsPlugin.getInstance().errorlog(e);
        }
        catch (InterruptedException e) {
            MessageDialog.openWarning((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("SyncSelectionRemoteAction.3"), (String)e.getMessage());
        }
        return false;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public class SyncSelectionRemoteDialog
    extends Dialog {
        private TableViewer viewer;

        public SyncSelectionRemoteDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.getString("SyncSelectionRemoteDialog.0"));
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.createTableArea(composite);
            return composite;
        }

        private void createTableArea(Composite parent) {
            Composite thisArea = new Composite(parent, 0);
            thisArea.setLayout((Layout)new GridLayout());
            Label label = new Label(thisArea, 0);
            label.setText(Messages.getString("SyncSelectionRemoteDialog.1"));
            Table table = new Table(thisArea, 68352);
            table.setLinesVisible(false);
            table.setHeaderVisible(true);
            TableLayout tableLayout = new TableLayout();
            table.setLayout((Layout)tableLayout);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(80, true));
            TableColumn tcAddress = new TableColumn(table, 0, 0);
            tcAddress.setText(Messages.getString("SyncSelectionRemoteDialog.2"));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(110, true));
            TableColumn tcUser = new TableColumn(table, 0, 1);
            tcUser.setText(Messages.getString("SyncSelectionRemoteDialog.3"));
            this.viewer = new TableViewer(table);
            GridData gridData = new GridData(768);
            gridData.heightHint = 150;
            gridData.widthHint = 230;
            this.viewer.getControl().setLayoutData((Object)gridData);
            this.viewer.setContentProvider((IContentProvider)this.getTableContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)this.getTableLabelProvider());
            ClientInfo[] clientInfo = ClientList.getClientInfoList();
            ArrayList<ClientInfo> clientInfoExceptMe = new ArrayList<ClientInfo>();
            int i = 0;
            while (i < clientInfo.length) {
                ClientInfo info = clientInfo[i];
                if (!BTSUtility.isLocalHost(info)) {
                    clientInfoExceptMe.add(info);
                }
                ++i;
            }
            this.viewer.setInput(clientInfoExceptMe);
            this.viewer.getTable().setSelection(0);
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ SyncSelectionRemoteDialog this$1;
                {
                    this.this$1 = syncSelectionRemoteDialog;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    SyncSelectionRemoteDialog.access$0(this.this$1, 0).setEnabled(SyncSelectionRemoteDialog.access$1(this.this$1).getTable().getSelectionCount() != 0);
                }
            });
        }

        private IStructuredContentProvider getTableContentProvider() {
            return new IStructuredContentProvider(this){
                final /* synthetic */ SyncSelectionRemoteDialog this$1;
                {
                    this.this$1 = syncSelectionRemoteDialog;
                }

                public Object[] getElements(Object inputElement) {
                    return ((List)inputElement).toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            };
        }

        private ILabelProvider getTableLabelProvider() {
            return new TableLabelProvider();
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, Messages.getString("SyncSelectionRemoteDialog.4"), true);
            this.getButton(0).setEnabled(this.viewer.getTable().getSelectionCount() != 0);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void okPressed() {
            ISelection selection = this.viewer.getSelection();
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            ClientInfo clientInfo = (ClientInfo)obj;
            if (clientInfo == null) {
                return;
            }
            super.okPressed();
            SyncIssue syncIssue = new SyncIssue(new NetworkConfig(), clientInfo.getClientAddress(), clientInfo.getPort());
            syncIssue.setRemoteUserName(clientInfo.getClientName());
            syncIssue.execute();
            SyncSelectionRemoteAction.this.finished = syncIssue.isFinished();
        }

        protected void cancelPressed() {
            super.cancelPressed();
            MessageDialog.openWarning((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("SyncSelectionRemoteDialog.5"), (String)Messages.getString("SyncSelectionRemoteDialog.6"));
        }

        static /* synthetic */ Button access$0(SyncSelectionRemoteDialog syncSelectionRemoteDialog, int n) {
            return syncSelectionRemoteDialog.getButton(n);
        }

        static /* synthetic */ TableViewer access$1(SyncSelectionRemoteDialog syncSelectionRemoteDialog) {
            return syncSelectionRemoteDialog.viewer;
        }

        private class TableLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            private Image image = BtsPlugin.getInstance().getImage("sync1.gif");

            TableLabelProvider() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return this.image;
                    }
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((ClientInfo)element).getClientAddress();
                    }
                    case 1: {
                        return ((ClientInfo)element).getClientName();
                    }
                }
                return "";
            }
        }
    }
}

