/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.editor;

import java.text.SimpleDateFormat;
import java.util.Date;
import jp.valtech.bts.data.CommentHistory;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.editor.AbstractIssueEditorPart;
import jp.valtech.bts.ui.editor.IssueMultiPageEditor;
import jp.valtech.bts.ui.editor.Messages;
import jp.valtech.bts.util.Logging;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class CommentPart
extends AbstractIssueEditorPart
implements Logging {
    public static final String TAB_TITLE = Messages.getString("CommentPart.0");
    private static final RGB DARK_BLUE = new RGB(0, 0, 204);
    private static final RGB DARK_GREEN = new RGB(0, 128, 0);
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat(Messages.getString("CommentPart.1"));
    private static final String END_LINE = "\n\n";
    private ScrolledForm form;
    private Text commentTxt;
    private StyledText historyTxt;
    IssueMultiPageEditor parentEditor;

    public CommentPart(IssueMultiPageEditor parentEditor) {
        this.parentEditor = parentEditor;
    }

    public void createPartControl(Composite parent) {
        try {
            Composite body = this.createBody(parent, Messages.getString("CommentPart.2"));
            this.createCommentSection(body);
            this.form.reflow(false);
        }
        catch (Exception e) {
            String msg = Messages.getString("CommentPart.3");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }

    private Composite createBody(Composite parent, String title) {
        if (this.toolkit == null) {
            this.getFormToolkit(parent);
        }
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setText(title);
        this.form.getBody().setLayout((Layout)layout);
        this.form.getBody().setLayoutData((Object)new GridData(1808));
        Composite body = this.toolkit.createComposite(this.form.getBody());
        body.setLayout((Layout)layout);
        body.setLayoutData((Object)new GridData(1808));
        return body;
    }

    private void createCommentSection(Composite parent) throws Exception {
        Section section = this.createSection(parent, Messages.getString("CommentPart.4"));
        section.setDescription(Messages.getString("CommentPart.5"));
        Composite composite = this.toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)composite);
        SashForm sashForm = new SashForm(composite, 256);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.createInputArea((Composite)sashForm);
        this.createHistoryArea((Composite)sashForm);
        sashForm.setWeights(new int[]{40, 60});
    }

    private void createInputArea(Composite composite) throws Exception {
        Composite thisArea = this.toolkit.createComposite(composite);
        this.toolkit.paintBordersFor(thisArea);
        thisArea.setLayout((Layout)new GridLayout());
        thisArea.setLayoutData((Object)new GridData(1808));
        this.toolkit.createLabel(thisArea, Messages.getString("CommentPart.6"));
        this.commentTxt = this.toolkit.createText(thisArea, "", 834);
        GridData gridData = new GridData(768);
        gridData.heightHint = 100;
        this.commentTxt.setLayoutData((Object)gridData);
        Link link = new Link(thisArea, 0);
        link.setText(Messages.getString("CommentPart.7"));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommentPart.this.parentEditor.changeOverviewPage();
            }
        });
        GridData gridLink = new GridData(768);
        gridLink.horizontalSpan = 2;
        gridLink.verticalIndent = 5;
        link.setLayoutData((Object)gridLink);
        link.setBackground(COLOR_WHITE);
    }

    private void createHistoryArea(Composite composite) throws Exception {
        Composite thisArea = this.toolkit.createComposite(composite);
        this.toolkit.paintBordersFor(thisArea);
        thisArea.setLayout((Layout)new GridLayout());
        thisArea.setLayoutData((Object)new GridData(1808));
        this.toolkit.createLabel(thisArea, Messages.getString("CommentPart.8"));
        this.historyTxt = new StyledText(thisArea, 8389130);
        GridData gridData = new GridData(1808);
        this.historyTxt.setLayoutData((Object)gridData);
        this.historyTxt.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        CommentHistory[] commentHistories = this.issueDisplayValue.getCommentHistories();
        this.setHistoryTxt(commentHistories);
    }

    String getNewComment() {
        return this.commentTxt.getText();
    }

    void postSave(CommentHistory[] commentHistories) {
        this.setHistoryTxt(commentHistories);
        this.commentTxt.setText("");
    }

    private void setHistoryTxt(CommentHistory[] commentHistories) {
        this.historyTxt.setText("");
        if (commentHistories == null) {
            return;
        }
        int idx = 0;
        while (idx < commentHistories.length) {
            Date date = commentHistories[idx].getUpdateDate();
            String dateStr = FORMATTER.format(date);
            CommentPart.setStyle(this.historyTxt, dateStr, DARK_BLUE, 0);
            String userName = String.valueOf(Messages.getString("CommentPart.9")) + commentHistories[idx].getUpdateUser() + END_LINE;
            CommentPart.setStyle(this.historyTxt, userName, DARK_GREEN, 0);
            String desc = String.valueOf(commentHistories[idx].getDescription()) + END_LINE;
            this.historyTxt.append(desc);
            ++idx;
        }
    }

    public void setFocus() {
        this.commentTxt.setFocus();
    }

    public boolean isDirty() {
        return false;
    }

    protected void fireIssueChange() {
    }
}

