/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueStatus;
import jp.valtech.bts.data.OutputDetails;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.editor.IssueDetailsExportDialog;
import jp.valtech.bts.ui.editor.IssueMultiPageEditor;
import jp.valtech.bts.ui.editor.Messages;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.Logging;

public class IssueDetailsExport
implements Logging {
    private IssueDetailsExportDialog dialog;
    private String fileName = null;
    private String filterPath;

    public IssueDetailsExport(IssueDetailsExportDialog dialog, String fileName, String filterPath) {
        this.dialog = dialog;
        this.fileName = fileName;
        this.filterPath = filterPath;
    }

    public void exportRun() {
        BtsPlugin.getInstance().copy("doc/output.css", String.valueOf(this.filterPath) + "/output.css");
        this.outputFile(this.setDetails());
    }

    private void outputFile(Object object) {
        try {
            if (this.dialog.fileXMLRdi.getSelection()) {
                BTSUtility.serialize(new File(this.fileName), object);
            } else if (this.dialog.fileHTMRdi.getSelection()) {
                BTSUtility.serialize(new File(String.valueOf(this.filterPath) + "/tmp.xml"), object);
                TransformerFactory factory = TransformerFactory.newInstance();
                URL url = BtsPlugin.getInstance().getURL("doc/outputDetails.xsl");
                InputStream inputStream = url.openStream();
                Transformer transformer = factory.newTransformer(new StreamSource(inputStream));
                transformer.setOutputProperty("encoding", "UTF-8");
                FileInputStream in = new FileInputStream(String.valueOf(this.filterPath) + "/tmp.xml");
                FileOutputStream out = new FileOutputStream(this.fileName);
                transformer.transform(new StreamSource(in), new StreamResult(out));
                inputStream.close();
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            String msg = Messages.getString("IssueDetailsExport.3");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
    }

    private OutputDetails setDetails() {
        IssueMultiPageEditor editorPart = BtsPlugin.getInstance().getActiveEditor();
        Issue issue = editorPart.getModifiedIssue();
        OutputDetails outputDetails = new OutputDetails();
        outputDetails.setIssueId(issue.getDisplayIssueID());
        outputDetails.setCreateUser(issue.getCreateUser());
        outputDetails.setCategory(issue.getCategory());
        outputDetails.setTitle(issue.getTitle());
        outputDetails.setDescription(issue.getDescription());
        outputDetails.setPriority(issue.getPriority());
        outputDetails.setStatus(IssueStatus.getEnumFromValue(issue.getStatus()).getDescription());
        outputDetails.setAssigned(issue.getAssigned());
        outputDetails.setDeadLine(BTSUtility.formatDate(issue.getDeadline(), "yyyy/MM/dd"));
        outputDetails.setCreateDate(BTSUtility.formatDate(issue.getCreateDate()));
        outputDetails.setUpdateDate(BTSUtility.formatDate(issue.getUpdateDate()));
        outputDetails.setHeader(this.dialog.headerTxt.getText().trim());
        outputDetails.setFooter(this.dialog.footerTxt.getText().trim());
        if (issue.getSecretBug().booleanValue()) {
            outputDetails.setSecretBug("ON");
        } else {
            outputDetails.setSecretBug("OFF");
        }
        if (issue.getSuspend().booleanValue()) {
            outputDetails.setSuspend("ON");
        } else {
            outputDetails.setSuspend("OFF");
        }
        if (((List)this.dialog.attachViewer.getInput()).size() == 0) {
            outputDetails.setAttach(Messages.getString("IssueDetailsExport.0"));
        } else {
            outputDetails.setAttach(Messages.getString("IssueDetailsExport.1"));
        }
        return outputDetails;
    }
}

