/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.editor;

import java.util.ArrayList;
import jp.valtech.bts.data.CommentHistory;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.ui.editor.Messages;
import jp.valtech.bts.util.BTSUtility;

public class IssueDisplayValue {
    private static final String TEMPOLARY_ISSUE_ID_LABLEL = Messages.getString("IssueDisplayValue.0");
    private Issue issue = new Issue();

    public void setIssue(Issue issue) {
        this.issue = issue;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public String getCreateDate() {
        if (this.issue.getCreateDate() == null) {
            return "";
        }
        return BTSUtility.formatDate(this.issue.getCreateDate());
    }

    public String getCreateUser() {
        if (this.issue.getCreateUser() == null) {
            return "";
        }
        return this.issue.getCreateUser();
    }

    public String getUpdateDate() {
        if (this.issue.getUpdateDate() == null) {
            return "";
        }
        return BTSUtility.formatDate(this.issue.getUpdateDate());
    }

    public String getVersion() {
        return "Ver." + this.issue.getVersion().toString();
    }

    public String getDisplayIssueID() {
        if ("".equals(this.issue.getDisplayIssueID())) {
            return TEMPOLARY_ISSUE_ID_LABLEL;
        }
        return this.issue.getDisplayIssueID();
    }

    public String getCategory() {
        if (this.issue.getCategory() == null) {
            return "";
        }
        return this.issue.getCategory();
    }

    public String getTitle() {
        if (this.issue.getTitle() == null) {
            return "";
        }
        return this.issue.getTitle();
    }

    public String getDescription() {
        if (this.issue.getDescription() == null) {
            return "";
        }
        return this.issue.getDescription();
    }

    public String getPriority() {
        if (this.issue.getPriority() == null) {
            return "";
        }
        return this.issue.getPriority();
    }

    public boolean isStatusOpened() {
        if (this.issue.getStatus() == null) {
            return true;
        }
        return this.issue.getStatus().equals("1");
    }

    public boolean isStatusAssigned() {
        if (this.issue.getStatus() == null) {
            return false;
        }
        return this.issue.getStatus().equals("2");
    }

    public boolean isStatusResolved() {
        if (this.issue.getStatus() == null) {
            return false;
        }
        return this.issue.getStatus().equals("3");
    }

    public boolean isStatusVerified() {
        if (this.issue.getStatus() == null) {
            return false;
        }
        return this.issue.getStatus().equals("4");
    }

    public boolean isStatusClosed() {
        if (this.issue.getStatus() == null) {
            return false;
        }
        return this.issue.getStatus().equals("5");
    }

    public String getAssigned() {
        if (this.issue.getAssigned() == null) {
            return "";
        }
        return this.issue.getAssigned();
    }

    public String getDeadline() {
        if (this.issue.getDeadline() == null) {
            return "";
        }
        return BTSUtility.formatDate(this.issue.getDeadline(), "yyyy/MM/dd");
    }

    public boolean isSecretBug() {
        if (this.issue.isSecretBug() == null) {
            return false;
        }
        return this.issue.isSecretBug();
    }

    public boolean isSuspend() {
        if (this.issue.isSuspend() == null) {
            return false;
        }
        return this.issue.isSuspend();
    }

    public ArrayList getAttachmentList() {
        ArrayList list = this.issue.getAttachmentList();
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public CommentHistory[] getCommentHistories() {
        return this.issue.getCommentHistories();
    }
}

