/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.editor;

import java.util.ArrayList;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.ui.editor.IssueDisplayValue;
import jp.valtech.bts.ui.editor.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class IssueMultiPageEditorInput
implements IEditorInput {
    public static final int OPEN_NEW_ISSUE = 0;
    public static final int OPEN_EXIST_ISSUE = 1;
    private int openMode = 0;
    private IssueDisplayValue issueDisplayValue = new IssueDisplayValue();
    private Issue issue;
    private ArrayList saveAttachment;

    public int getOpenMode() {
        return this.openMode;
    }

    public void setOpenMode(int openMode) {
        this.openMode = openMode;
    }

    public void setIssue(Issue issue) {
        this.issue = issue;
        ArrayList attachmentList = issue.getAttachmentList();
        if (attachmentList == null) {
            this.saveAttachment = new ArrayList();
        }
        this.saveAttachment = (ArrayList)attachmentList.clone();
        this.issueDisplayValue.setIssue(issue);
    }

    public void resetIssue(Issue issue) {
        this.openMode = 1;
        this.setIssue(issue);
    }

    public Issue getIssue() {
        return this.issue;
    }

    public ArrayList getSavedAttachment() {
        return this.saveAttachment;
    }

    public IssueDisplayValue getIssueDisplayValue() {
        return this.issueDisplayValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (this.issue == null) {
            return false;
        }
        if (o instanceof IssueMultiPageEditorInput) {
            IssueMultiPageEditorInput that = (IssueMultiPageEditorInput)o;
            return this.issue.equals(that.getIssue());
        }
        return false;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.openMode == 1) {
            return this.issueDisplayValue.getTitle();
        }
        return Messages.getString("IssueMultiPageEditorInput.0");
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        if (this.openMode == 1) {
            return String.valueOf(this.issueDisplayValue.getDisplayIssueID()) + ":" + this.issueDisplayValue.getTitle();
        }
        return Messages.getString("IssueMultiPageEditorInput.1");
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

