/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.issuelist;

import java.util.List;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;
import jp.valtech.bts.ui.IBtsViewPart;
import jp.valtech.bts.ui.issuelist.Messages;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class IssueListViewContentProvider
implements IStructuredContentProvider,
IBtsListener,
Logging {
    private TableViewer viewer;
    private IBtsViewPart viewPart;

    public IssueListViewContentProvider(IBtsViewPart viewPart) {
        this.viewPart = viewPart;
        BtsPlugin.getInstance().addListener(this);
    }

    public Object[] getElements(Object inputElement) {
        return ((List)inputElement).toArray();
    }

    public void dispose() {
        BtsPlugin.getInstance().removeListener(this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TableViewer)viewer;
    }

    public void addIssue(final Issue newIssue) {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    List issueList = (List)IssueListViewContentProvider.this.viewer.getInput();
                    issueList.add(newIssue);
                    IssueListViewContentProvider.this.viewer.insert((Object)newIssue, 0);
                    IssueListViewContentProvider.this.viewer.refresh();
                    Table table = IssueListViewContentProvider.this.viewer.getTable();
                    IssueListViewContentProvider.this.viewPart.updateDescription(table.getItemCount());
                }
                catch (Exception e) {
                    String msg = Messages.getString("IssueListViewContentProvider.0");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }

    public void updateIssue(final Issue oldIssue, final Issue newIssue) {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    List issueList = (List)IssueListViewContentProvider.this.viewer.getInput();
                    if (oldIssue != null) {
                        issueList.remove(oldIssue);
                        IssueListViewContentProvider.this.viewer.remove((Object)oldIssue);
                    }
                    if (!issueList.contains(newIssue)) {
                        issueList.add(newIssue);
                        IssueListViewContentProvider.this.viewer.insert((Object)newIssue, 0);
                    }
                    IssueListViewContentProvider.this.viewer.refresh();
                    Table table = IssueListViewContentProvider.this.viewer.getTable();
                    IssueListViewContentProvider.this.viewPart.updateDescription(table.getItemCount());
                }
                catch (Exception e) {
                    String msg = Messages.getString("IssueListViewContentProvider.1");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }

    public void deleteIssue(final Issue deleteIssue) {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    List issueList = (List)IssueListViewContentProvider.this.viewer.getInput();
                    issueList.remove(deleteIssue);
                    IssueListViewContentProvider.this.viewer.remove((Object)deleteIssue);
                    Table table = IssueListViewContentProvider.this.viewer.getTable();
                    IssueListViewContentProvider.this.viewPart.updateDescription(table.getItemCount());
                }
                catch (Exception e) {
                    String msg = Messages.getString("IssueListViewContentProvider.2");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }

    public void joinMember(ClientInfo clientInfo) {
    }

    public void leaveMember(ClientInfo clientInfo) {
    }

    public void addMessage(MessagePacket messagePacket) {
    }

    public void deleteMessage(MessagePacket messagePacket) {
    }

    public void refresh(final List issueList) {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    List oldIssueList = (List)IssueListViewContentProvider.this.viewer.getInput();
                    oldIssueList.clear();
                    IssueListViewContentProvider.this.viewer.refresh();
                    IssueListViewContentProvider.this.viewer.setInput((Object)issueList);
                    IssueListViewContentProvider.this.viewPart.updateDescription(issueList.size());
                }
                catch (Exception e) {
                    String msg = Messages.getString("IssueListViewContentProvider.3");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }

    public void clear() {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    List list = (List)IssueListViewContentProvider.this.viewer.getInput();
                    list.clear();
                    IssueListViewContentProvider.this.viewer.refresh();
                }
                catch (Exception e) {
                    String msg = Messages.getString("IssueListViewContentProvider.4");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }
}

