/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.issuelist;

import jp.valtech.bts.data.Issue;
import jp.valtech.bts.util.BTSUtility;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class IssueListViewSorter
extends ViewerSorter {
    private boolean reversed = false;
    private int columnNumber;

    public IssueListViewSorter(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result = 0;
        result = this.compareColumnValue((Issue)e1, (Issue)e2);
        if (this.reversed) {
            result = -result;
        }
        return result;
    }

    int compareColumnValue(Issue e1, Issue e2) {
        switch (this.columnNumber) {
            case 0: {
                return this.compareTo(BTSUtility.judgeLimit(e1), BTSUtility.judgeLimit(e2));
            }
            case 1: {
                return e1.getDisplayIssueID().compareTo(e2.getDisplayIssueID());
            }
            case 2: {
                return this.compareTo(e1.getTitle(), e2.getTitle());
            }
            case 3: {
                return this.compareTo(e1.getCategory(), e2.getCategory());
            }
            case 4: {
                return this.compareTo(e1.getPriority(), e2.getPriority());
            }
            case 5: {
                return this.compareTo(e1.getStatus(), e2.getStatus());
            }
            case 6: {
                return this.compareTo(e1.getAssigned(), e2.getAssigned());
            }
            case 7: {
                return this.compareTo(e1.getCreateDate(), e2.getCreateDate());
            }
        }
        return 0;
    }

    private int compareTo(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        if (obj1 != null && obj2 == null) {
            return 1;
        }
        if (obj1 == null && obj2 != null) {
            return -1;
        }
        return ((Comparable)obj1).compareTo((Comparable)obj2);
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }
}

