/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.msglist;

import java.text.SimpleDateFormat;
import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.ui.BtsPlugin;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class MessageListViewLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider,
IFontProvider {
    private static final Color COLOR_RED = Display.getDefault().getSystemColor(3);
    private static final Color COLOR_BLUE = new Color((Device)Display.getCurrent(), 0, 0, 204);
    private static final Font FONT_BOLD = new Font((Device)Display.getDefault(), new FontData("", 9, 1));
    private static final Image IMG_ISSUE = BtsPlugin.getInstance().getImage("msg_issue.gif");
    private static final Image IMG_ISSUE_OPEN = BtsPlugin.getInstance().getImage("msg_issue_opn.gif");
    private static final Image IMG_USER = BtsPlugin.getInstance().getImage("msg_user.gif");
    private static final Image IMG_USER_OPEN = BtsPlugin.getInstance().getImage("msg_user_opn.gif");
    private static final Image IMG_USER_ATACH = BtsPlugin.getInstance().getImage("msg_user_atch.gif");
    private static final Image IMG_USER_ATACHOP = BtsPlugin.getInstance().getImage("msg_user_atch_opn.gif");
    private static final Image IMG_SYNC = BtsPlugin.getInstance().getImage("sync1.gif");
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private static final String RETURN_STR = "\n";

    public String getColumnText(Object obj, int index) {
        MessagePacket messagePacket = (MessagePacket)obj;
        switch (index) {
            case 1: {
                String msg = messagePacket.getMessage();
                if (msg != null && msg.indexOf(RETURN_STR) != -1) {
                    return msg.substring(0, msg.indexOf(RETURN_STR));
                }
                return msg;
            }
            case 2: {
                return messagePacket.getFromUser();
            }
            case 3: {
                return FORMATTER.format(messagePacket.getSent());
            }
        }
        return "";
    }

    public Image getColumnImage(Object obj, int index) {
        MessagePacket msg = (MessagePacket)obj;
        switch (index) {
            case 0: {
                if ("S".equals(msg.getMessageType())) {
                    return IMG_SYNC;
                }
                if ("C".equals(msg.getMessageType())) {
                    if (!msg.isOpend().booleanValue()) {
                        return IMG_ISSUE;
                    }
                    return IMG_ISSUE_OPEN;
                }
                if ("I".equals(msg.getMessageType())) {
                    if (!msg.isOpend().booleanValue()) {
                        return IMG_ISSUE;
                    }
                    return IMG_ISSUE_OPEN;
                }
                if (!"U".equals(msg.getMessageType())) break;
                if (msg.getAttachFileName() == null || "".equals(msg.getAttachFileName())) {
                    if (!msg.isOpend().booleanValue()) {
                        return IMG_USER;
                    }
                    return IMG_USER_OPEN;
                }
                if (!msg.isOpend().booleanValue()) {
                    return IMG_USER_ATACH;
                }
                return IMG_USER_ATACHOP;
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        MessagePacket messagePacket = (MessagePacket)element;
        if ("C".equals(messagePacket.getMessageType())) {
            return COLOR_RED;
        }
        if ("U".equals(messagePacket.getMessageType())) {
            return COLOR_BLUE;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Font getFont(Object element) {
        MessagePacket messagePacket = (MessagePacket)element;
        if (!messagePacket.getOpened().booleanValue()) {
            return FONT_BOLD;
        }
        return null;
    }
}

