/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.msglist;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import jp.valtech.bts.command.client.SendMessage;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.facade.SendMessageFacade;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.network.ClientList;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.msglist.Messages;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.IOUtility;
import jp.valtech.bts.util.Logging;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class MessageSenderDialog
extends Dialog
implements Logging {
    private CheckboxTableViewer viewer;
    private Text pathTxt;
    private Text msgText;
    private String message = "";
    private ClientInfo toClient;
    private boolean sendAll = false;

    public MessageSenderDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setReplyMessage(String message) {
        this.message = message;
    }

    public void setClientInfo(ClientInfo clientInfo) {
        this.toClient = clientInfo;
    }

    public void setSendAll(boolean sendAll) {
        this.sendAll = sendAll;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("MessageSenderDialog.0"));
    }

    protected Control createDialogArea(Composite parent) {
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayoutData((Object)new GridData(1808));
        try {
            this.createTableArea((Composite)sashForm);
            this.createRightPain((Composite)sashForm);
            sashForm.setWeights(new int[]{40, 60});
            this.createSeparatorLine(parent);
        }
        catch (Exception e) {
            String msg = Messages.getString("MessageSenderDialog.20");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
        return sashForm;
    }

    private void createTableArea(Composite parent) {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setLayout((Layout)new GridLayout());
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("MessageSenderDialog.1"));
        Table table = new Table(thisArea, 68384);
        table.setLinesVisible(false);
        table.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        TableColumn tcAddress = new TableColumn(table, 0, 0);
        tcAddress.setText(Messages.getString("MessageSenderDialog.2"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        TableColumn tcUser = new TableColumn(table, 0, 1);
        tcUser.setText(Messages.getString("MessageSenderDialog.3"));
        this.viewer = new CheckboxTableViewer(table);
        GridData gridData = new GridData(768);
        gridData.heightHint = 210;
        gridData.widthHint = 230;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.setContentProvider((IContentProvider)this.getTableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getTableLabelProvider());
        ClientInfo[] clientInfo = ClientList.getClientInfoList();
        ArrayList<ClientInfo> clientInfoExceptMe = new ArrayList<ClientInfo>();
        int i = 0;
        while (i < clientInfo.length) {
            ClientInfo info = clientInfo[i];
            if (!BTSUtility.isLocalHost(info)) {
                clientInfoExceptMe.add(info);
            }
            ++i;
        }
        this.viewer.setInput(clientInfoExceptMe);
        if (this.toClient == null) {
            this.viewer.setAllChecked(this.sendAll);
        } else {
            this.viewer.setCheckedElements((Object[])new ClientInfo[]{this.toClient});
        }
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MessageSenderDialog.this.getButton(0).setEnabled(MessageSenderDialog.this.viewer.getCheckedElements().length != 0);
            }
        });
    }

    private IStructuredContentProvider getTableContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private ILabelProvider getTableLabelProvider() {
        return new TableLabelProvider();
    }

    private void createRightPain(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        thisArea.setLayout((Layout)gridLayout);
        this.createMessageArea(thisArea);
        this.createAttachmentArea(thisArea);
    }

    private void createMessageArea(Composite thisArea) throws Exception {
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("MessageSenderDialog.4"));
        GridData gridData = new GridData(4);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.msgText = new Text(thisArea, 2882);
        gridData = new GridData(768);
        gridData.widthHint = 300;
        gridData.heightHint = 200;
        gridData.horizontalSpan = 3;
        this.msgText.setLayoutData((Object)gridData);
        if (this.message != null) {
            this.msgText.setText(this.message);
        }
    }

    private void createAttachmentArea(final Composite thisArea) throws Exception {
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("MessageSenderDialog.5"));
        this.pathTxt = new Text(thisArea, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 240;
        this.pathTxt.setLayoutData((Object)gridData);
        Button exportBtn = new Button(thisArea, 8);
        exportBtn.setText(Messages.getString("MessageSenderDialog.6"));
        exportBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(thisArea.getShell(), 4096);
                String path = dialog.open();
                if (path != null) {
                    MessageSenderDialog.this.pathTxt.setText(path);
                }
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.getString("MessageSenderDialog.7"), true);
        this.getButton(0).setEnabled(this.viewer.getCheckedElements().length != 0);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void createSeparatorLine(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        separator.setLayoutData((Object)gd);
    }

    protected void okPressed() {
        MessagePacket packet = this.createMessagepacket();
        if (packet == null) {
            return;
        }
        SendMessageFacade facade = new SendMessageFacade();
        facade.addMessage(packet);
        boolean res = this.sendMessage(packet);
        if (!res) {
            return;
        }
        super.okPressed();
    }

    private MessagePacket createMessagepacket() {
        MessagePacket packet = new MessagePacket();
        String sendMessage = this.msgText.getText();
        packet.setMessage(sendMessage);
        String attachmentPath = this.pathTxt.getText().trim();
        if (!attachmentPath.equals("")) {
            File file = new File(attachmentPath);
            if (!file.exists()) {
                MessageDialog.openInformation((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("MessageSenderDialog.8"), (String)Messages.getString("MessageSenderDialog.9"));
                return null;
            }
            try {
                byte[] entity = IOUtility.read(attachmentPath);
                packet.setAttachFile(entity);
                packet.setAttachFileName(file.getName());
            }
            catch (Exception e) {
                BtsPlugin.getInstance().errorlog(e);
                MessageDialog.openInformation((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("MessageSenderDialog.10"), (String)Messages.getString("MessageSenderDialog.11"));
                return null;
            }
        } else {
            packet.setAttachFile(null);
            packet.setAttachFileName(null);
        }
        ProjectConfig config = CurrentProject.getInsance().getProjectConfig();
        packet.setFromUser(config.getUserName());
        packet.setSent(System.currentTimeMillis());
        packet.setMessageType("U");
        return packet;
    }

    protected boolean sendMessage(final MessagePacket messagePacket) {
        try {
            final Object[] clientInfos = this.viewer.getCheckedElements();
            if (clientInfos == null || clientInfos.length == 0) {
                MessageDialog.openInformation((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("MessageSenderDialog.12"), (String)Messages.getString("MessageSenderDialog.13"));
                return false;
            }
            IRunnableWithProgress progress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.getString("MessageSenderDialog.14"), clientInfos.length);
                    int i = 0;
                    while (i < clientInfos.length) {
                        ClientInfo info = (ClientInfo)clientInfos[i];
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        SendMessage send = new SendMessage(new NetworkConfig(), info.getClientAddress(), info.getPort());
                        send.setMessagePacket(messagePacket);
                        monitor.subTask(String.valueOf(Messages.getString("MessageSenderDialog.15")) + info.getClientName() + Messages.getString("MessageSenderDialog.16"));
                        try {
                            send.execute();
                        }
                        catch (Exception e) {
                            logger.fatal((Object)(String.valueOf(Messages.getString("MessageSenderDialog.17")) + info), (Throwable)e);
                            throw new InterruptedException(e.getMessage());
                        }
                        monitor.worked(1);
                        ++i;
                    }
                    monitor.done();
                }
            };
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(BtsPlugin.getInstance().getShell());
            dialog.run(true, true, progress);
            return true;
        }
        catch (InvocationTargetException e) {
            BtsPlugin.getInstance().errorlog(e);
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openInformation((Shell)BtsPlugin.getInstance().getShell(), (String)Messages.getString("MessageSenderDialog.18"), (String)Messages.getString("MessageSenderDialog.19"));
        }
        return false;
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image image = BtsPlugin.getInstance().getImage("msg_list_view.gif");

        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.image;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((ClientInfo)element).getClientAddress();
                }
                case 1: {
                    return ((ClientInfo)element).getClientName();
                }
            }
            return "";
        }
    }
}

