/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.navigator;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jp.valtech.bts.dao.BtsDBException;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.IssueHistory;
import jp.valtech.bts.data.IssueStatus;
import jp.valtech.bts.data.OutputAssigned;
import jp.valtech.bts.data.OutputBugChart;
import jp.valtech.bts.data.OutputIssues;
import jp.valtech.bts.data.OutputStatus;
import jp.valtech.bts.facade.IssueHistoryFacade;
import jp.valtech.bts.facade.ModifyIssueFacade;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.navigator.IssueClassifiedExportDialog;
import jp.valtech.bts.ui.navigator.Messages;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.util.BTSUtility;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.time.Day;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public class IssueClassifiedExport {
    private IssueClassifiedExportDialog dialog;
    private List issueList;
    private String fileName = null;
    private String filterPath;
    private String[] assigned;
    private Timestamp minTimestamp;
    private Timestamp maxTimestamp;
    private int[] updateOpenTotal;
    private int[] updateCloseTotal;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public IssueClassifiedExport(IssueClassifiedExportDialog dialog, List issueList, String fileName, String filterPath) {
        this.dialog = dialog;
        this.issueList = issueList;
        this.fileName = fileName;
        this.filterPath = filterPath;
    }

    public void exportRun() {
        if (this.dialog.issueListRdi.getSelection()) {
            this.outputFile(this.setIssues());
        } else if (this.dialog.cntAssignedRdi.getSelection()) {
            this.outputFile(this.setAssigned());
        } else if (this.dialog.cntStatusRdi.getSelection()) {
            this.outputFile(this.setStatus());
        } else if (this.dialog.totalBugRdi.getSelection()) {
            this.outputFile(this.setBugChart());
        }
    }

    private void outputFile(Object object) {
        try {
            if (this.dialog.fileXMLRdi.getSelection()) {
                BTSUtility.serialize(new File(this.fileName), object);
            } else if (this.dialog.fileHTMRdi.getSelection()) {
                BtsPlugin.getInstance().copy("doc/output.css", String.valueOf(this.filterPath) + "/output.css");
                BTSUtility.serialize(new File(String.valueOf(this.filterPath) + "/tmp.xml"), object);
                TransformerFactory factory = TransformerFactory.newInstance();
                URL url = null;
                if (this.dialog.issueListRdi.getSelection()) {
                    BtsPlugin.getInstance().copy("icons/error1.gif", String.valueOf(this.filterPath) + "/error1.gif");
                    BtsPlugin.getInstance().copy("icons/warning1.gif", String.valueOf(this.filterPath) + "/warning1.gif");
                    url = BtsPlugin.getInstance().getURL("doc/outputIssues.xsl");
                } else if (this.dialog.cntAssignedRdi.getSelection()) {
                    url = BtsPlugin.getInstance().getURL("doc/outputAssigned.xsl");
                } else if (this.dialog.cntStatusRdi.getSelection()) {
                    url = BtsPlugin.getInstance().getURL("doc/outputStatus.xsl");
                } else if (this.dialog.totalBugRdi.getSelection()) {
                    url = BtsPlugin.getInstance().getURL("doc/outputBugChart.xsl");
                }
                InputStream inputStream = url.openStream();
                Transformer transformer = factory.newTransformer(new StreamSource(inputStream));
                transformer.setOutputProperty("encoding", "UTF-8");
                FileInputStream in = new FileInputStream(String.valueOf(this.filterPath) + "/tmp.xml");
                FileOutputStream out = new FileOutputStream(this.fileName);
                transformer.transform(new StreamSource(in), new StreamResult(out));
                inputStream.close();
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            BtsPlugin.getInstance().errorlog(e);
        }
    }

    private OutputIssues[] setIssues() {
        OutputIssues[] outputIssue = new OutputIssues[this.issueList.size()];
        ProjectConfig config = CurrentProject.getInsance().getProjectConfig();
        String limit = null;
        limit = config.isUntilDeadLineCheck() ? config.getUntilDeadLine() : "-";
        int i = 0;
        while (i < this.issueList.size()) {
            Issue issue = (Issue)this.issueList.get(i);
            int limitType = BTSUtility.judgeLimit(issue);
            outputIssue[i] = new OutputIssues();
            outputIssue[i].setDeadline(Integer.toString(limitType));
            outputIssue[i].setIssueID(issue.getDisplayIssueID());
            outputIssue[i].setTitle(issue.getTitle());
            outputIssue[i].setCategory(issue.getCategory());
            outputIssue[i].setPriority(issue.getPriority());
            outputIssue[i].setStatusValue(issue.getStatus());
            outputIssue[i].setStatus(IssueStatus.getEnumFromValue(issue.getStatus()).getDescription());
            outputIssue[i].setAssigned(issue.getAssigned());
            outputIssue[i].setCreateDate(BTSUtility.formatDate(issue.getCreateDate()));
            outputIssue[i].setHeader(this.dialog.headerTxt.getText().trim());
            outputIssue[i].setFooter(this.dialog.footerTxt.getText().trim());
            outputIssue[i].setNowDate(BTSUtility.formatDate(new Date()));
            outputIssue[i].setLimit(limit);
            outputIssue[i].setIssueNum(Integer.toString(this.issueList.size()));
            ++i;
        }
        return outputIssue;
    }

    private OutputAssigned[] setAssigned() {
        int assignedCnt = 0;
        int assignedSum = 0;
        int resolvedCnt = 0;
        int resolvedSum = 0;
        int verifiedCnt = 0;
        int verifiedSum = 0;
        int closedCnt = 0;
        int closedSum = 0;
        int sum = 0;
        int allSum = 0;
        try {
            CurrentProject project = CurrentProject.getInsance();
            if (project.isOpen()) {
                ModifyIssueFacade issueModifyFacade = new ModifyIssueFacade();
                this.assigned = issueModifyFacade.getAssignedTypeR();
            }
        }
        catch (BtsDBException e) {
            BtsPlugin.getInstance().errorlog(e);
        }
        OutputAssigned[] outputAssigned = new OutputAssigned[this.assigned.length + 1];
        int i = 0;
        while (i < this.assigned.length) {
            assignedCnt = 0;
            resolvedCnt = 0;
            verifiedCnt = 0;
            closedCnt = 0;
            sum = 0;
            int j = 0;
            while (j < this.issueList.size()) {
                Issue issue = (Issue)this.issueList.get(j);
                String status = issue.getStatus();
                if (this.assigned[i].equals(issue.getAssigned())) {
                    if ("2".equals(status)) {
                        ++assignedCnt;
                    } else if ("3".equals(status)) {
                        ++resolvedCnt;
                    } else if ("4".equals(status)) {
                        ++verifiedCnt;
                    } else if ("5".equals(status)) {
                        ++closedCnt;
                    }
                }
                ++j;
            }
            sum = assignedCnt + resolvedCnt + verifiedCnt + closedCnt;
            outputAssigned[i + 1] = new OutputAssigned();
            outputAssigned[i + 1].setAssigned(this.assigned[i]);
            outputAssigned[i + 1].setAssignedCnt(Integer.toString(assignedCnt));
            outputAssigned[i + 1].setResolvedCnt(Integer.toString(resolvedCnt));
            outputAssigned[i + 1].setVerifiedCnt(Integer.toString(verifiedCnt));
            outputAssigned[i + 1].setClosedCnt(Integer.toString(closedCnt));
            outputAssigned[i + 1].setSum(Integer.toString(sum));
            try {
                outputAssigned[i + 1].setAssignedRate(this.rateCalculate(assignedCnt, sum));
            }
            catch (Exception exception) {
                outputAssigned[i + 1].setAssignedRate("0.0");
            }
            assignedSum += assignedCnt;
            resolvedSum += resolvedCnt;
            verifiedSum += verifiedCnt;
            closedSum += closedCnt;
            allSum += sum;
            ++i;
        }
        outputAssigned[0] = new OutputAssigned();
        outputAssigned[0].setAssignedSum(Integer.toString(assignedSum));
        outputAssigned[0].setResolvedSum(Integer.toString(resolvedSum));
        outputAssigned[0].setVerifiedSum(Integer.toString(verifiedSum));
        outputAssigned[0].setClosedSum(Integer.toString(closedSum));
        outputAssigned[0].setAllSum(Integer.toString(allSum));
        outputAssigned[0].setOpenedCnt(Integer.toString(this.issueList.size() - allSum));
        try {
            outputAssigned[0].setAssignedRateAvg(this.rateCalculate(assignedSum, allSum));
        }
        catch (Exception exception) {
            outputAssigned[0].setAssignedRateAvg("0.0");
        }
        outputAssigned[0].setHeader(this.dialog.headerTxt.getText().trim());
        outputAssigned[0].setFooter(this.dialog.footerTxt.getText().trim());
        outputAssigned[0].setNowDate(BTSUtility.formatDate(new Date()));
        return outputAssigned;
    }

    private OutputStatus setStatus() {
        int openedCnt = 0;
        int openedOverCnt = 0;
        int assignedCnt = 0;
        int assignedOverCnt = 0;
        int resolvedCnt = 0;
        int resolvedOverCnt = 0;
        int verifiedCnt = 0;
        int verifiedOverCnt = 0;
        int closedCnt = 0;
        int i = 0;
        while (i < this.issueList.size()) {
            Issue issue = (Issue)this.issueList.get(i);
            boolean judge = this.deadLineOver(issue);
            String status = issue.getStatus();
            if ("1".equals(status)) {
                ++openedCnt;
                if (judge) {
                    ++openedOverCnt;
                }
            } else if ("2".equals(status)) {
                ++assignedCnt;
                if (judge) {
                    ++assignedOverCnt;
                }
            } else if ("3".equals(status)) {
                ++resolvedCnt;
                if (judge) {
                    ++resolvedOverCnt;
                }
            } else if ("4".equals(status)) {
                ++verifiedCnt;
                if (judge) {
                    ++verifiedOverCnt;
                }
            } else {
                ++closedCnt;
            }
            ++i;
        }
        int notClosedSum = openedCnt + assignedCnt + resolvedCnt + verifiedCnt;
        int notClosedOverSum = openedOverCnt + assignedOverCnt + resolvedOverCnt + verifiedOverCnt;
        int statusSum = notClosedSum + closedCnt;
        OutputStatus outputStatus = new OutputStatus();
        outputStatus.setOpenedCnt(Integer.toString(openedCnt));
        outputStatus.setOpenedOverCnt(Integer.toString(openedOverCnt));
        outputStatus.setAssignedCnt(Integer.toString(assignedCnt));
        outputStatus.setAssignedOverCnt(Integer.toString(assignedOverCnt));
        outputStatus.setResolvedCnt(Integer.toString(resolvedCnt));
        outputStatus.setResolvedOverCnt(Integer.toString(resolvedOverCnt));
        outputStatus.setVerifiedCnt(Integer.toString(verifiedCnt));
        outputStatus.setVerifiedOverCnt(Integer.toString(verifiedOverCnt));
        outputStatus.setClosedCnt(Integer.toString(closedCnt));
        outputStatus.setNotClosedSum(Integer.toString(notClosedSum));
        outputStatus.setNotClosedOverSum(Integer.toString(notClosedOverSum));
        outputStatus.setStatusSum(Integer.toString(statusSum));
        outputStatus.setHeader(this.dialog.headerTxt.getText().trim());
        outputStatus.setFooter(this.dialog.footerTxt.getText().trim());
        outputStatus.setNowDate(BTSUtility.formatDate(new Date()));
        return outputStatus;
    }

    private OutputBugChart[] setBugChart() {
        this.countBug();
        this.createChart();
        OutputBugChart[] outputBugCharts = new OutputBugChart[this.updateOpenTotal.length];
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.minTimestamp.getTime());
        int i = 0;
        while (i < this.updateOpenTotal.length) {
            outputBugCharts[i] = new OutputBugChart();
            outputBugCharts[i].setOpenedBug(Integer.toString(this.updateOpenTotal[i]));
            outputBugCharts[i].setClosedBug(Integer.toString(this.updateCloseTotal[i]));
            outputBugCharts[i].setRemainBug(Integer.toString(this.updateOpenTotal[i] - this.updateCloseTotal[i]));
            outputBugCharts[i].setHeader(this.dialog.headerTxt.getText().trim());
            outputBugCharts[i].setFooter(this.dialog.footerTxt.getText().trim());
            outputBugCharts[i].setNowDate(BTSUtility.formatDate(new Date()));
            if (this.dialog.unitMonthRdi.getSelection()) {
                outputBugCharts[i].setDate(BTSUtility.formatDate(calendar.getTime(), "yyyy/M"));
                outputBugCharts[i].setUnit(Messages.getString("IssueClassifiedExport.6"));
                calendar.add(2, 1);
            } else if (this.dialog.unitWeekRdi.getSelection()) {
                calendar.set(7, 1);
                outputBugCharts[i].setDate(BTSUtility.formatDate(calendar.getTime(), "M/d"));
                outputBugCharts[i].setUnit(Messages.getString("IssueClassifiedExport.7"));
                calendar.add(3, 1);
            } else {
                outputBugCharts[i].setDate(BTSUtility.formatDate(calendar.getTime(), "M/d"));
                outputBugCharts[i].setUnit(Messages.getString("IssueClassifiedExport.8"));
                calendar.add(5, 1);
            }
            ++i;
        }
        return outputBugCharts;
    }

    /*
     * Unable to fully structure code
     */
    private void countBug() {
        this.minTimestamp = new Timestamp(9999999999999L);
        this.maxTimestamp = new Timestamp(0L);
        bugChartList = this.getIssueHistoryForChart();
        calendarMin = Calendar.getInstance();
        calendarMin.setTimeInMillis(this.minTimestamp.getTime());
        calendarMax = Calendar.getInstance();
        calendarMax.setTimeInMillis(this.maxTimestamp.getTime());
        minYear = calendarMin.get(1);
        maxYear = calendarMax.get(1);
        minMonth = 0;
        maxMonth = 0;
        minWeek = 0;
        maxWeek = 0;
        minDay = 0;
        maxDay = 0;
        if (this.dialog.unitMonthRdi.getSelection()) {
            minMonth = calendarMin.get(2) + 1;
            maxMonth = calendarMax.get(2) + 1;
            argsNumMax = (maxYear - minYear) * 12 + maxMonth - minMonth + 1;
        } else if (this.dialog.unitWeekRdi.getSelection()) {
            minWeek = calendarMin.get(3);
            maxWeek = calendarMax.get(3);
            argsNumMax = (maxYear - minYear) * 52 + maxWeek - minWeek + 1;
        } else {
            minDay = calendarMin.get(6);
            maxDay = calendarMax.get(6);
            argsNumMax = (maxYear - minYear) * 365 + maxDay - minDay + 1;
        }
        this.updateOpenTotal = new int[argsNumMax];
        this.updateCloseTotal = new int[argsNumMax];
        calendar = Calendar.getInstance();
        i = 0;
        while (i < bugChartList.size()) {
            block7: {
                updateDateLong = ((IssueHistory)bugChartList.get(i)).getUpdateDateTimestamp();
                calendar.setTimeInMillis(updateDateLong);
                updateYear = calendar.get(1);
                argsNum = this.dialog.unitMonthRdi.getSelection() != false ? (updateYear - minYear) * 12 + calendar.get(2) + 1 - minMonth : (this.dialog.unitWeekRdi.getSelection() != false ? (updateYear - minYear) * 52 + calendar.get(3) - minWeek : (updateYear - minYear) * 365 + calendar.get(6) - minDay);
                if (!IssueHistory.ISSUE_INITIAL_REGIST.equals(((IssueHistory)bugChartList.get(i)).getUpdateAttribute())) ** GOTO lbl46
                while (argsNum < this.updateOpenTotal.length) {
                    v0 = argsNum++;
                    this.updateOpenTotal[v0] = this.updateOpenTotal[v0] + 1;
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    v1 = argsNum++;
                    this.updateCloseTotal[v1] = this.updateCloseTotal[v1] + 1;
lbl46:
                    // 2 sources

                    ** while (argsNum < this.updateOpenTotal.length)
                }
            }
            ++i;
        }
    }

    private void createChart() {
        Class<?> klass;
        if (this.dialog.unitMonthRdi.getSelection()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.jfree.data.time.Month");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            klass = clazz;
        } else if (this.dialog.unitWeekRdi.getSelection()) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.jfree.data.time.Week");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            klass = clazz;
        } else {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.jfree.data.time.Day");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            klass = clazz;
        }
        TimeSeries openTimeSeries = new TimeSeries(Messages.getString("IssueClassifiedExport.0"), (Class)klass);
        TimeSeries closeTimeSeries = new TimeSeries(Messages.getString("IssueClassifiedExport.1"), klass);
        TimeSeries remainderTimeSeries = new TimeSeries(Messages.getString("IssueClassifiedExport.2"), klass);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.minTimestamp.getTime());
        int i = 0;
        while (i < this.updateOpenTotal.length) {
            Month timePeriod;
            if (this.dialog.unitMonthRdi.getSelection()) {
                timePeriod = new Month(calendar.get(2) + 1, calendar.get(1));
                calendar.add(2, 1);
            } else if (this.dialog.unitWeekRdi.getSelection()) {
                timePeriod = new Week(calendar.get(3), calendar.get(1));
                calendar.add(3, 1);
            } else {
                timePeriod = new Day(calendar.get(5), calendar.get(2) + 1, calendar.get(1));
                calendar.add(5, 1);
            }
            openTimeSeries.add((RegularTimePeriod)timePeriod, (double)this.updateOpenTotal[i]);
            closeTimeSeries.add((RegularTimePeriod)timePeriod, (double)this.updateCloseTotal[i]);
            remainderTimeSeries.add((RegularTimePeriod)timePeriod, (double)(this.updateOpenTotal[i] - this.updateCloseTotal[i]));
            ++i;
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(openTimeSeries);
        dataset.addSeries(closeTimeSeries);
        dataset.addSeries(remainderTimeSeries);
        JFreeChart chart = ChartFactory.createTimeSeriesChart(null, null, (String)Messages.getString("IssueClassifiedExport.3"), (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)new Color(239, 238, 254));
        TextTitle textTitle = new TextTitle(Messages.getString("IssueClassifiedExport.4"));
        textTitle.setFont(new Font("SansSerif", 1, 16));
        textTitle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        chart.addSubtitle((Title)textTitle);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        xyplot.setDomainGridlinesVisible(false);
        DateAxis dateaxis = (DateAxis)xyplot.getDomainAxis();
        TickUnits tickUnits = new TickUnits();
        if (this.dialog.unitWeekRdi.getSelection()) {
            tickUnits.add((TickUnit)new DateTickUnit(2, 7, (DateFormat)new SimpleDateFormat("M/d")));
        } else if (this.dialog.unitDayRdi.getSelection()) {
            tickUnits.add((TickUnit)new DateTickUnit(2, 1, (DateFormat)new SimpleDateFormat("M/d")));
            tickUnits.add((TickUnit)new DateTickUnit(2, 7, (DateFormat)new SimpleDateFormat("M/d")));
        }
        tickUnits.add((TickUnit)new DateTickUnit(1, 1, (DateFormat)new SimpleDateFormat("yyyy/M")));
        tickUnits.add((TickUnit)new DateTickUnit(1, 3, (DateFormat)new SimpleDateFormat("yyyy/M")));
        tickUnits.add((TickUnit)new DateTickUnit(1, 6, (DateFormat)new SimpleDateFormat("yyyy/M")));
        dateaxis.setStandardTickUnits((TickUnitSource)tickUnits);
        dateaxis.setAutoTickUnitSelection(true);
        NumberAxis axis = (NumberAxis)xyplot.getRangeAxis();
        axis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LegendTitle legendtitle = (LegendTitle)chart.getSubtitle(0);
        legendtitle.setPosition(RectangleEdge.RIGHT);
        File outputFile = new File(String.valueOf(this.filterPath) + "/bug.png");
        try {
            ChartUtilities.saveChartAsPNG((File)outputFile, (JFreeChart)chart, (int)1000, (int)400);
        }
        catch (IOException e) {
            BtsPlugin.getInstance().errorlog(e);
        }
    }

    private List getIssueHistoryForChart() {
        ArrayList<IssueHistory> issueHistorys = new ArrayList<IssueHistory>();
        IssueHistoryFacade facade = new IssueHistoryFacade();
        int i = 0;
        while (i < this.issueList.size()) {
            Issue issue = (Issue)this.issueList.get(i);
            IssueHistory[] filterIssueHistories = facade.getByFingerPrint(issue.getFingerPrint(), issue.getType());
            int j = 0;
            while (j < filterIssueHistories.length) {
                String updateAttribute = filterIssueHistories[j].getUpdateAttribute();
                String updateAfter = filterIssueHistories[j].getUpdateAfter();
                if (IssueHistory.ISSUE_INITIAL_REGIST.equals(updateAttribute) || Messages.getString("IssueClassifiedExport.5").equals(updateAttribute) && IssueStatus.CLOSED.getDescription().equals(updateAfter)) {
                    issueHistorys.add(filterIssueHistories[j]);
                    Timestamp updateDateTimestamp = new Timestamp(filterIssueHistories[j].getUpdateDateTimestamp());
                    if (this.minTimestamp.compareTo(updateDateTimestamp) > 0) {
                        this.minTimestamp = updateDateTimestamp;
                    }
                    if (this.maxTimestamp.compareTo(updateDateTimestamp) < 0) {
                        this.maxTimestamp = updateDateTimestamp;
                    }
                }
                ++j;
            }
            ++i;
        }
        facade.close();
        return issueHistorys;
    }

    private String rateCalculate(int x, int y) throws Exception {
        double rate = (double)x * 100.0 / (double)y;
        BigDecimal bd = new BigDecimal(String.valueOf(rate));
        rate = bd.setScale(1, 4).doubleValue();
        return Double.toString(rate);
    }

    private boolean deadLineOver(Issue issue) {
        long nowDate = new Date().getTime();
        Calendar calendarNow = Calendar.getInstance();
        calendarNow.setTimeInMillis(nowDate);
        if (issue.getDeadline() != null) {
            long deadLine = issue.getDeadlineTimestamp();
            Calendar calendarDead = Calendar.getInstance();
            calendarDead.setTimeInMillis(deadLine);
            if (calendarNow.get(6) > calendarDead.get(6)) {
                return true;
            }
        }
        return false;
    }
}

