/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.navigator;

import java.util.List;
import jp.valtech.bts.command.client.Join;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.network.ClientList;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;
import jp.valtech.bts.ui.navigator.BtsTreeNode;
import jp.valtech.bts.ui.navigator.MemberListNode;
import jp.valtech.bts.ui.navigator.MemberNode;
import jp.valtech.bts.ui.navigator.Messages;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.ui.navigator.ProjectConfigManager;
import jp.valtech.bts.ui.navigator.ProjectNode;
import jp.valtech.bts.ui.navigator.TreeBuilder;
import jp.valtech.bts.ui.navigator.TreeHelper;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class NavigatorViewContentProvider
implements ITreeContentProvider,
IBtsListener,
Logging {
    private TreeViewer viewer;

    public NavigatorViewContentProvider() {
        BtsPlugin.getInstance().addListener(this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
    }

    public Object[] getElements(Object rootNode) {
        List project = ((BtsTreeNode)rootNode).getChildren();
        return project.toArray();
    }

    public Object[] getChildren(Object parent) {
        List children = ((BtsTreeNode)parent).getChildren();
        return children.toArray();
    }

    public boolean hasChildren(Object object) {
        return ((BtsTreeNode)object).hasChildren();
    }

    public Object getParent(Object child) {
        return ((BtsTreeNode)child).getParent();
    }

    public void dispose() {
        BtsPlugin.getInstance().removeListener(this);
    }

    public void addIssue(final Issue issue) {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    CurrentProject current = CurrentProject.getInsance();
                    String ssid = current.getSSID();
                    BtsTreeNode rootNode = (BtsTreeNode)NavigatorViewContentProvider.this.viewer.getInput();
                    ProjectNode projectNode = (ProjectNode)rootNode.getChild(ssid);
                    TreeHelper.incrementIssueCount(issue, projectNode);
                    NavigatorViewContentProvider.this.viewer.refresh((Object)projectNode);
                }
                catch (Exception e) {
                    String msg = Messages.getString("NavigatorViewContentProvider.0");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }

    public void updateIssue(final Issue oldIssue, final Issue newIssue) {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    CurrentProject current = CurrentProject.getInsance();
                    String ssid = current.getSSID();
                    BtsTreeNode rootNode = (BtsTreeNode)NavigatorViewContentProvider.this.viewer.getInput();
                    ProjectNode projectNode = (ProjectNode)rootNode.getChild(ssid);
                    if (oldIssue != null) {
                        TreeHelper.decrementIssueCount(oldIssue, projectNode);
                    }
                    TreeHelper.incrementIssueCount(newIssue, projectNode);
                    NavigatorViewContentProvider.this.viewer.refresh((Object)projectNode);
                }
                catch (Exception e) {
                    String msg = Messages.getString("NavigatorViewContentProvider.1");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }

    public void deleteIssue(final Issue deleteIssue) {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    CurrentProject current = CurrentProject.getInsance();
                    String ssid = current.getSSID();
                    BtsTreeNode rootNode = (BtsTreeNode)NavigatorViewContentProvider.this.viewer.getInput();
                    ProjectNode projectNode = (ProjectNode)rootNode.getChild(ssid);
                    TreeHelper.decrementIssueCount(deleteIssue, projectNode);
                    NavigatorViewContentProvider.this.viewer.refresh((Object)projectNode);
                }
                catch (Exception e) {
                    String msg = Messages.getString("NavigatorViewContentProvider.2");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }

    public void joinMember(final ClientInfo clientInfo) {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    CurrentProject current = CurrentProject.getInsance();
                    String ssid = current.getSSID();
                    BtsTreeNode rootNode = (BtsTreeNode)NavigatorViewContentProvider.this.viewer.getInput();
                    ProjectNode projectNode = (ProjectNode)rootNode.getChild(ssid);
                    MemberListNode memberListNode = projectNode.getMemberListNode();
                    if (memberListNode == null) {
                        return;
                    }
                    MemberNode memberNode = (MemberNode)memberListNode.getChild(clientInfo.getClientAddress());
                    if (memberNode == null) {
                        memberNode = new MemberNode(memberListNode, clientInfo);
                        memberListNode.addChild(memberNode);
                        NavigatorViewContentProvider.this.viewer.add((Object)memberListNode, (Object)memberNode);
                        NavigatorViewContentProvider.this.viewer.refresh((Object)memberListNode);
                    } else {
                        memberNode.setTextName(clientInfo.getClientName());
                        NavigatorViewContentProvider.this.viewer.refresh((Object)memberListNode);
                    }
                }
                catch (Exception e) {
                    String msg = Messages.getString("NavigatorViewContentProvider.3");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }

    public void leaveMember(final ClientInfo clientInfo) {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    CurrentProject current = CurrentProject.getInsance();
                    String ssid = current.getSSID();
                    BtsTreeNode rootNode = (BtsTreeNode)NavigatorViewContentProvider.this.viewer.getInput();
                    ProjectNode projectNode = (ProjectNode)rootNode.getChild(ssid);
                    MemberListNode memberListNode = projectNode.getMemberListNode();
                    if (memberListNode == null) {
                        return;
                    }
                    BtsTreeNode removeNode = memberListNode.getChild(clientInfo.getClientAddress());
                    if (removeNode != null) {
                        memberListNode.removeChild(removeNode);
                        NavigatorViewContentProvider.this.viewer.remove((Object)removeNode);
                        NavigatorViewContentProvider.this.viewer.refresh((Object)memberListNode);
                    }
                }
                catch (Exception e) {
                    String msg = Messages.getString("NavigatorViewContentProvider.4");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }

    public void addMessage(MessagePacket messagePacket) {
    }

    public void deleteMessage(MessagePacket messagePacket) {
    }

    public void refresh(final List issueList) {
        if (this.viewer == null) {
            return;
        }
        ClientList.clear();
        ClientList.addMyInfo();
        Control ctrl = this.viewer.getControl();
        ctrl.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    Issue[] issues = issueList.toArray(new Issue[issueList.size()]);
                    CurrentProject current = CurrentProject.getInsance();
                    TreeBuilder treeBuilder = new TreeBuilder();
                    ProjectConfig[] projectConfig = ProjectConfigManager.getProjectConfigs();
                    int i = 0;
                    while (i < projectConfig.length) {
                        String ssid = projectConfig[i].getSsid();
                        String name = projectConfig[i].getProjectName();
                        ProjectNode projectNode = treeBuilder.addProjectNode(name, ssid);
                        if (current.isCurrentProject(ssid)) {
                            projectNode.open();
                            treeBuilder.addIssueNode(ssid, issues);
                            treeBuilder.addMemberListNode(ssid, ClientList.getClientInfoList());
                        }
                        ++i;
                    }
                    NavigatorViewContentProvider.this.viewer.setInput((Object)treeBuilder.getRootNode());
                    Join join = new Join(new NetworkConfig());
                    join.execute();
                }
                catch (Exception e) {
                    String msg = Messages.getString("NavigatorViewContentProvider.5");
                    logger.fatal((Object)msg, (Throwable)e);
                    BtsPlugin.getInstance().error(msg, e);
                }
            }
        });
    }

    public void clear() {
    }
}

