/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.navigator;

import java.io.File;
import jp.valtech.bts.command.client.Join;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.facade.DatabaseInitializer;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.network.ClientList;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.navigator.Messages;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.ui.navigator.ProjectConfigDialogValidate;
import jp.valtech.bts.ui.navigator.ProjectConfigManager;
import jp.valtech.bts.ui.navigator.TreeHelper;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.Logging;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ProjectConfigDialog
extends TitleAreaDialog
implements Logging {
    public static final int TAB_INDEX_GENERAL = 0;
    public static final int TAB_INDEX_SYNC = 1;
    public static final int TAB_INDEX_ISSUE = 2;
    public static final int TAB_INDEX_MAIL = 3;
    private int tabIndex = 0;
    private GridData textSizeL;
    private GridData textSizeSS;
    private GridData labelSizeM;
    private GridData labelSizeS;
    private Text projectNameTxt;
    private Text userNameTxt;
    private Text ssidTxt;
    private Text categoryTxt;
    private Text priorityTxt;
    private Text assignedTxt;
    private Text voteTxt;
    private Button voteChk;
    private Text untilDeadLineTxt;
    private Button untilDeadLineChk;
    private Button mailChk;
    private Text smtpTxt;
    private Text senderTxt;
    private Text recipientTxt;
    private Text prefixTxt;
    private Button fixedSyncChk;
    private Text address1;
    private Text address2;
    private Text address3;
    private Text address4;
    private Text port;
    private Button autoSyncChk;
    private Button appointSyncRdi;
    private Label appointSyncLabel;
    private Button normalSyncRdi;
    private Label normalSyncLabel;
    private Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    private ProjectConfig oldConfig;

    public ProjectConfigDialog(Shell parentShell, String ssid) {
        super(parentShell);
        this.oldConfig = ProjectConfigManager.getProjectConfig(ssid);
    }

    public ProjectConfigDialog(Shell parentShell, String ssid, int openTabIndex) {
        super(parentShell);
        this.oldConfig = ProjectConfigManager.getProjectConfig(ssid);
        this.tabIndex = openTabIndex;
    }

    public ProjectConfigDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("ProjectConfigDialog.0"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "jp.valtech.bts.help.projectContext");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.createCommonLayout();
            if (this.oldConfig == null) {
                this.setTitle(Messages.getString("ProjectConfigDialog.1"));
                this.setMessage(Messages.getString("ProjectConfigDialog.2"));
            } else {
                this.setTitle(Messages.getString("ProjectConfigDialog.3"));
                this.setMessage(Messages.getString("ProjectConfigDialog.4"));
            }
            this.setTitleImage(BtsPlugin.getInstance().getImage("butterfly.gif"));
            TabFolder tabFolder = new TabFolder(composite, 0);
            tabFolder.setLayoutData((Object)new GridData(1808));
            this.createGeneraTab(tabFolder);
            this.createSyncTab(tabFolder);
            this.createIssueTab(tabFolder);
            this.createMailTab(tabFolder);
            tabFolder.setSelection(this.tabIndex);
        }
        catch (Exception e) {
            String msg = Messages.getString("ProjectConfigDialog.5");
            logger.fatal((Object)msg, (Throwable)e);
            BtsPlugin.getInstance().error(msg, e);
        }
        return composite;
    }

    private void createCommonLayout() {
        this.textSizeL = new GridData(4);
        this.textSizeL.widthHint = 290;
        this.textSizeSS = new GridData(4);
        this.textSizeSS.widthHint = 30;
        this.labelSizeM = new GridData(4);
        this.labelSizeM.widthHint = 70;
        this.labelSizeS = new GridData(4);
        this.labelSizeS.widthHint = 60;
    }

    private void createGeneraTab(TabFolder tabFolder) throws Exception {
        TabItem tab = new TabItem(tabFolder, 0);
        tab.setText(Messages.getString("ProjectConfigDialog.15"));
        Composite generalTab = new Composite((Composite)tabFolder, 0);
        generalTab.setLayout((Layout)new GridLayout());
        this.createGeneralTabHeaderArea(generalTab);
        this.createProjectNameArea(generalTab);
        this.createUserNameArea(generalTab);
        this.createSSIDArea(generalTab);
        this.createNotesArea(generalTab);
        tab.setControl((Control)generalTab);
    }

    private void createIssueTab(TabFolder tabFolder) throws Exception {
        TabItem tab = new TabItem(tabFolder, 0);
        tab.setText(Messages.getString("ProjectConfigDialog.6"));
        Composite issueTab = new Composite((Composite)tabFolder, 0);
        issueTab.setLayout((Layout)new GridLayout());
        this.createIssueTabHeaderArea(issueTab);
        this.createCategoryArea(issueTab);
        this.createPriorityArea(issueTab);
        this.createAssignedArea(issueTab);
        this.createVoteArea(issueTab);
        this.createUntilDeadLineArea(issueTab);
        tab.setControl((Control)issueTab);
    }

    private void createMailTab(TabFolder tabFolder) throws Exception {
        TabItem tab = new TabItem(tabFolder, 0);
        tab.setText(Messages.getString("ProjectConfigDialog.7"));
        Composite mailTab = new Composite((Composite)tabFolder, 0);
        mailTab.setLayout((Layout)new GridLayout());
        this.createMailTabHeaderArea(mailTab);
        this.createMailCheckArea(mailTab);
        this.createSmtpArea(mailTab);
        this.createSenderAddressArea(mailTab);
        this.createRecipientAddressArea(mailTab);
        this.createPrefixArea(mailTab);
        tab.setControl((Control)mailTab);
    }

    private void createSyncTab(TabFolder tabFolder) throws Exception {
        TabItem tab = new TabItem(tabFolder, 0);
        tab.setText(Messages.getString("ProjectConfigDialog.43"));
        Composite syncTab = new Composite((Composite)tabFolder, 0);
        syncTab.setLayout((Layout)new GridLayout());
        this.createSyncTabHeaderArea(syncTab);
        this.createFixedSyncArea(syncTab);
        this.createAutoSyncArea(syncTab);
        this.createNotesArea(syncTab);
        tab.setControl((Control)syncTab);
    }

    private void createGeneralTabHeaderArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setLayout((Layout)new GridLayout());
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.30"));
        label.setFont(this.boldFont);
    }

    private void createProjectNameArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 131072);
        label.setText(Messages.getString("ProjectConfigDialog.31"));
        label.setLayoutData((Object)this.labelSizeM);
        this.projectNameTxt = new Text(thisArea, 2048);
        this.projectNameTxt.setLayoutData((Object)this.textSizeL);
        this.projectNameTxt.setTextLimit(20);
        if (this.oldConfig != null) {
            this.projectNameTxt.setText(this.oldConfig.getProjectName());
        }
        this.projectNameTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
        label = new Label(thisArea, 0);
        label.setText("");
        label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.32"));
        label.setAlignment(131072);
    }

    private void createUserNameArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 131072);
        label.setText(Messages.getString("ProjectConfigDialog.33"));
        label.setLayoutData((Object)this.labelSizeM);
        this.userNameTxt = new Text(thisArea, 2048);
        this.userNameTxt.setLayoutData((Object)this.textSizeL);
        this.userNameTxt.setTextLimit(20);
        if (this.oldConfig != null) {
            this.userNameTxt.setText(this.oldConfig.getUserName());
        }
        this.userNameTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
        label = new Label(thisArea, 0);
        label.setText("");
        label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.34"));
        label.setAlignment(131072);
    }

    private void createSSIDArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 131072);
        label.setText(Messages.getString("ProjectConfigDialog.35"));
        label.setLayoutData((Object)this.labelSizeM);
        this.ssidTxt = new Text(thisArea, 2048);
        this.ssidTxt.setLayoutData((Object)this.textSizeL);
        this.ssidTxt.setTextLimit(20);
        if (this.oldConfig != null) {
            this.ssidTxt.setText(this.oldConfig.getSsid());
            this.ssidTxt.setEnabled(false);
        }
        this.ssidTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
        label = new Label(thisArea, 0);
        label.setText("");
        label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.36"));
        label.setAlignment(131072);
    }

    private void createNotesArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setLayout((Layout)new GridLayout());
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.40"));
        label.setForeground(new Color((Device)Display.getCurrent(), 49, 106, 197));
    }

    private void createIssueTabHeaderArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.29"));
        label.setFont(this.boldFont);
    }

    private void createCategoryArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 0);
        label.setText(String.valueOf(Messages.getString("ProjectConfigDialog.22")) + Messages.getString("ProjectConfigDialog.23"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label = new Label(thisArea, 131072);
        label.setText(Messages.getString("ProjectConfigDialog.24"));
        label.setLayoutData((Object)this.labelSizeS);
        this.categoryTxt = new Text(thisArea, 2048);
        this.categoryTxt.setLayoutData((Object)this.textSizeL);
        this.categoryTxt.setText(Messages.getString("ProjectConfigDialog.25"));
        if (this.oldConfig != null) {
            this.categoryTxt.setText(this.oldConfig.getCategory());
        }
        this.categoryTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
    }

    private void createPriorityArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 131072);
        label.setText(Messages.getString("ProjectConfigDialog.26"));
        label.setLayoutData((Object)this.labelSizeS);
        this.priorityTxt = new Text(thisArea, 2048);
        this.priorityTxt.setLayoutData((Object)this.textSizeL);
        this.priorityTxt.setText(Messages.getString("ProjectConfigDialog.27"));
        if (this.oldConfig != null) {
            this.priorityTxt.setText(this.oldConfig.getPriority());
        }
        this.priorityTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
    }

    private void createAssignedArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 131072);
        label.setText(Messages.getString("ProjectConfigDialog.28"));
        label.setLayoutData((Object)this.labelSizeS);
        this.assignedTxt = new Text(thisArea, 2048);
        this.assignedTxt.setLayoutData((Object)this.textSizeL);
        if (this.oldConfig != null) {
            this.assignedTxt.setText(this.oldConfig.getAssigned());
        }
        this.assignedTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
    }

    private void createVoteArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        thisArea.setLayout((Layout)gridLayout);
        this.voteChk = new Button(thisArea, 32);
        this.voteChk.setText(Messages.getString("ProjectConfigDialog.19"));
        this.voteChk.setSelection(true);
        this.voteChk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProjectConfigDialog.this.voteChk.getSelection()) {
                    ProjectConfigDialog.this.voteTxt.setEditable(true);
                } else {
                    ProjectConfigDialog.this.voteTxt.setEditable(false);
                }
                ProjectConfigDialog.this.okEnabled();
            }
        });
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.voteChk.setLayoutData((Object)data);
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.20"));
        GridData indent = new GridData();
        indent.horizontalIndent = 20;
        label.setLayoutData((Object)indent);
        this.voteTxt = new Text(thisArea, 2048);
        this.voteTxt.setLayoutData((Object)this.textSizeSS);
        this.voteTxt.setEditable(true);
        this.voteTxt.setText("20");
        if (this.oldConfig != null) {
            this.voteChk.setSelection(this.oldConfig.isVoteCheck());
            this.voteTxt.setText(this.oldConfig.getVote());
            if (this.oldConfig.isVoteCheck()) {
                this.voteTxt.setEditable(true);
            } else {
                this.voteTxt.setEditable(false);
            }
        }
        this.voteTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
        label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.21"));
    }

    private void createUntilDeadLineArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        thisArea.setLayout((Layout)gridLayout);
        this.untilDeadLineChk = new Button(thisArea, 32);
        this.untilDeadLineChk.setText(Messages.getString("ProjectConfigDialog.16"));
        this.untilDeadLineChk.setSelection(true);
        this.untilDeadLineChk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProjectConfigDialog.this.untilDeadLineChk.getSelection()) {
                    ProjectConfigDialog.this.untilDeadLineTxt.setEditable(true);
                } else {
                    ProjectConfigDialog.this.untilDeadLineTxt.setEditable(false);
                }
                ProjectConfigDialog.this.okEnabled();
            }
        });
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.untilDeadLineChk.setLayoutData((Object)data);
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.17"));
        GridData indent = new GridData();
        indent.horizontalIndent = 20;
        label.setLayoutData((Object)indent);
        this.untilDeadLineTxt = new Text(thisArea, 2048);
        this.untilDeadLineTxt.setLayoutData((Object)this.textSizeSS);
        this.untilDeadLineTxt.setEditable(true);
        this.untilDeadLineTxt.setText("1");
        if (this.oldConfig != null) {
            this.untilDeadLineChk.setSelection(this.oldConfig.isUntilDeadLineCheck());
            this.untilDeadLineTxt.setText(this.oldConfig.getUntilDeadLine());
            if (this.oldConfig.isUntilDeadLineCheck()) {
                this.untilDeadLineTxt.setEditable(true);
            } else {
                this.untilDeadLineTxt.setEditable(false);
            }
        }
        this.untilDeadLineTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
        label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.18"));
    }

    private void createMailTabHeaderArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.8"));
        label.setFont(this.boldFont);
    }

    private void createMailCheckArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setLayout((Layout)new GridLayout());
        this.mailChk = new Button(thisArea, 32);
        this.mailChk.setText(Messages.getString("ProjectConfigDialog.9"));
        this.mailChk.setSelection(false);
        if (this.oldConfig != null) {
            this.mailChk.setSelection(this.oldConfig.isMailCheck());
        }
        this.mailChk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProjectConfigDialog.this.mailChk.getSelection()) {
                    ProjectConfigDialog.this.smtpTxt.setEditable(true);
                    ProjectConfigDialog.this.senderTxt.setEditable(true);
                    ProjectConfigDialog.this.recipientTxt.setEditable(true);
                    ProjectConfigDialog.this.prefixTxt.setEditable(true);
                } else {
                    ProjectConfigDialog.this.smtpTxt.setEditable(false);
                    ProjectConfigDialog.this.senderTxt.setEditable(false);
                    ProjectConfigDialog.this.recipientTxt.setEditable(false);
                    ProjectConfigDialog.this.prefixTxt.setEditable(false);
                }
                ProjectConfigDialog.this.okEnabled();
            }
        });
    }

    private void createSmtpArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.10"));
        this.smtpTxt = new Text(thisArea, 2048);
        this.smtpTxt.setLayoutData((Object)this.textSizeL);
        this.smtpTxt.setEditable(false);
        if (this.oldConfig != null) {
            this.smtpTxt.setText(this.oldConfig.getSmtp());
            if (this.oldConfig.isMailCheck()) {
                this.smtpTxt.setEditable(true);
            } else {
                this.smtpTxt.setEditable(false);
            }
        }
        this.smtpTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
    }

    private void createSenderAddressArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.11"));
        this.senderTxt = new Text(thisArea, 2048);
        this.senderTxt.setLayoutData((Object)this.textSizeL);
        this.senderTxt.setEditable(false);
        if (this.oldConfig != null) {
            this.senderTxt.setText(this.oldConfig.getSender());
            if (this.oldConfig.isMailCheck()) {
                this.senderTxt.setEditable(true);
            } else {
                this.senderTxt.setEditable(false);
            }
        }
        this.senderTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
    }

    private void createRecipientAddressArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.12"));
        this.recipientTxt = new Text(thisArea, 2048);
        this.recipientTxt.setLayoutData((Object)this.textSizeL);
        this.recipientTxt.setEditable(false);
        if (this.oldConfig != null) {
            this.recipientTxt.setText(this.oldConfig.getRecipient());
            if (this.oldConfig.isMailCheck()) {
                this.recipientTxt.setEditable(true);
            } else {
                this.recipientTxt.setEditable(false);
            }
        }
        this.recipientTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
        label = new Label(thisArea, 0);
        label.setText("");
        label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.13"));
        label.setAlignment(131072);
    }

    private void createPrefixArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginLeft = 16;
        thisArea.setLayout((Layout)gridLayout);
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.14"));
        GridData data = new GridData();
        data.heightHint = 37;
        label.setLayoutData((Object)data);
        this.prefixTxt = new Text(thisArea, 2048);
        this.prefixTxt.setLayoutData((Object)this.textSizeL);
        this.prefixTxt.setText("[BTS]");
        this.prefixTxt.setEditable(false);
        if (this.oldConfig != null) {
            this.prefixTxt.setText(this.oldConfig.getPrefix());
            if (this.oldConfig.isMailCheck()) {
                this.prefixTxt.setEditable(true);
            } else {
                this.prefixTxt.setEditable(false);
            }
        }
        this.prefixTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
    }

    private void createSyncTabHeaderArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setLayout((Layout)new GridLayout());
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.44"));
        label.setFont(this.boldFont);
    }

    private void createFixedSyncArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        thisArea.setLayout((Layout)gridLayout);
        this.fixedSyncChk = new Button(thisArea, 32);
        this.fixedSyncChk.setText(Messages.getString("ProjectConfigDialog.45"));
        this.fixedSyncChk.setSelection(false);
        GridData data = new GridData();
        data.horizontalSpan = 8;
        this.fixedSyncChk.setLayoutData((Object)data);
        if (this.oldConfig != null) {
            this.fixedSyncChk.setSelection(this.oldConfig.isFixedSyncCheck());
        }
        this.fixedSyncChk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean flag = ProjectConfigDialog.this.fixedSyncChk.getSelection();
                ProjectConfigDialog.this.address1.setEditable(flag);
                ProjectConfigDialog.this.address2.setEditable(flag);
                ProjectConfigDialog.this.address3.setEditable(flag);
                ProjectConfigDialog.this.address4.setEditable(flag);
                ProjectConfigDialog.this.port.setEditable(flag);
                ProjectConfigDialog.this.normalSyncRdi.setEnabled(flag && ProjectConfigDialog.this.autoSyncChk.getSelection());
                ProjectConfigDialog.this.normalSyncLabel.setEnabled(flag && ProjectConfigDialog.this.autoSyncChk.getSelection());
                if (!flag) {
                    ProjectConfigDialog.this.normalSyncRdi.setSelection(false);
                    ProjectConfigDialog.this.appointSyncRdi.setSelection(true);
                }
                ProjectConfigDialog.this.okEnabled();
            }
        });
        Label label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.46"));
        GridData labelData = new GridData();
        labelData.horizontalIndent = 15;
        label.setLayoutData((Object)labelData);
        this.address1 = new Text(thisArea, 2048);
        this.address1.setTextLimit(3);
        this.address1.setEditable(false);
        this.address1.setLayoutData((Object)this.textSizeSS);
        if (this.oldConfig != null) {
            this.address1.setText(this.oldConfig.getAddress1());
            this.address1.setEditable(this.oldConfig.isFixedSyncCheck());
        }
        this.address1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
        label = new Label(thisArea, 0);
        label.setText(".");
        this.address2 = new Text(thisArea, 2048);
        this.address2.setTextLimit(3);
        this.address2.setEditable(false);
        this.address2.setLayoutData((Object)this.textSizeSS);
        if (this.oldConfig != null) {
            this.address2.setText(this.oldConfig.getAddress2());
            this.address2.setEditable(this.oldConfig.isFixedSyncCheck());
        }
        this.address2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
        label = new Label(thisArea, 0);
        label.setText(".");
        this.address3 = new Text(thisArea, 2048);
        this.address3.setTextLimit(3);
        this.address3.setEditable(false);
        this.address3.setLayoutData((Object)this.textSizeSS);
        if (this.oldConfig != null) {
            this.address3.setText(this.oldConfig.getAddress3());
            this.address3.setEditable(this.oldConfig.isFixedSyncCheck());
        }
        this.address3.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
        label = new Label(thisArea, 0);
        label.setText(".");
        this.address4 = new Text(thisArea, 2048);
        this.address4.setTextLimit(3);
        this.address4.setEditable(false);
        this.address4.setLayoutData((Object)this.textSizeSS);
        if (this.oldConfig != null) {
            this.address4.setText(this.oldConfig.getAddress4());
            this.address4.setEditable(this.oldConfig.isFixedSyncCheck());
        }
        this.address4.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
        label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.47"));
        label.setLayoutData((Object)labelData);
        this.port = new Text(thisArea, 2048);
        this.port.setTextLimit(5);
        this.port.setText("4344");
        this.port.setEditable(false);
        GridData portData = new GridData();
        portData.widthHint = 30;
        portData.horizontalSpan = 7;
        this.port.setLayoutData((Object)portData);
        if (this.oldConfig != null) {
            this.port.setText(this.oldConfig.getPort());
            this.port.setEditable(this.oldConfig.isFixedSyncCheck());
        }
        this.port.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
        label = new Label(thisArea, 0);
        label.setText(Messages.getString("ProjectConfigDialog.48"));
        GridData noteData = new GridData();
        noteData.horizontalSpan = 8;
        noteData.horizontalIndent = 15;
        label.setLayoutData((Object)noteData);
    }

    private void createAutoSyncArea(Composite parent) throws Exception {
        Composite thisArea = new Composite(parent, 0);
        thisArea.setLayout((Layout)new GridLayout());
        this.autoSyncChk = new Button(thisArea, 32);
        this.autoSyncChk.setText(Messages.getString("ProjectConfigDialog.37"));
        this.autoSyncChk.setSelection(true);
        GridData data = new GridData();
        this.autoSyncChk.setLayoutData((Object)data);
        if (this.oldConfig != null) {
            this.autoSyncChk.setSelection(this.oldConfig.isAutoSyncCheck());
        }
        this.autoSyncChk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectConfigDialog.this.normalSyncRdi.setEnabled(ProjectConfigDialog.this.autoSyncChk.getSelection() && ProjectConfigDialog.this.fixedSyncChk.getSelection());
                ProjectConfigDialog.this.normalSyncLabel.setEnabled(ProjectConfigDialog.this.autoSyncChk.getSelection() && ProjectConfigDialog.this.fixedSyncChk.getSelection());
                ProjectConfigDialog.this.appointSyncRdi.setEnabled(ProjectConfigDialog.this.autoSyncChk.getSelection());
                ProjectConfigDialog.this.appointSyncLabel.setEnabled(ProjectConfigDialog.this.autoSyncChk.getSelection());
                ProjectConfigDialog.this.okEnabled();
            }
        });
        this.normalSyncRdi = new Button(thisArea, 16);
        this.normalSyncRdi.setText(Messages.getString("ProjectConfigDialog.38"));
        this.normalSyncRdi.setSelection(false);
        this.normalSyncRdi.setEnabled(false);
        data = new GridData();
        data.horizontalIndent = 15;
        this.normalSyncRdi.setLayoutData((Object)data);
        if (this.oldConfig != null) {
            this.normalSyncRdi.setSelection(this.oldConfig.isNormalSyncRadio());
            this.normalSyncRdi.setEnabled(this.oldConfig.isAutoSyncCheck() && this.oldConfig.isFixedSyncCheck());
        }
        this.normalSyncRdi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
        this.normalSyncLabel = new Label(thisArea, 0);
        this.normalSyncLabel.setText(Messages.getString("ProjectConfigDialog.41"));
        this.normalSyncLabel.setEnabled(false);
        data = new GridData();
        data.horizontalIndent = 33;
        this.normalSyncLabel.setLayoutData((Object)data);
        if (this.oldConfig != null) {
            this.normalSyncLabel.setEnabled(this.oldConfig.isAutoSyncCheck() && this.oldConfig.isFixedSyncCheck());
        }
        this.appointSyncRdi = new Button(thisArea, 16);
        this.appointSyncRdi.setText(Messages.getString("ProjectConfigDialog.39"));
        this.appointSyncRdi.setSelection(true);
        data = new GridData();
        data.horizontalIndent = 15;
        this.appointSyncRdi.setLayoutData((Object)data);
        if (this.oldConfig != null) {
            this.appointSyncRdi.setSelection(this.oldConfig.isAppointSyncRadio());
            this.appointSyncRdi.setEnabled(this.oldConfig.isAutoSyncCheck());
        }
        this.appointSyncRdi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectConfigDialog.this.okEnabled();
            }
        });
        this.appointSyncLabel = new Label(thisArea, 0);
        this.appointSyncLabel.setText(Messages.getString("ProjectConfigDialog.42"));
        data = new GridData();
        data.horizontalIndent = 33;
        this.appointSyncLabel.setLayoutData((Object)data);
        if (this.oldConfig != null) {
            this.appointSyncLabel.setEnabled(this.oldConfig.isAutoSyncCheck());
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        ProjectConfig newconf = this.save();
        CurrentProject current = CurrentProject.getInsance();
        if (current.isCurrentProject(newconf)) {
            current.setProjectConfig(newconf);
        }
        this.refreshView(newconf);
        if (this.oldConfig == null) {
            this.createNewProject(newconf);
        }
        super.okPressed();
    }

    private void createNewProject(ProjectConfig newconf) {
        String ssidDir = BTSUtility.getBaseDir(newconf.getSsid());
        File dir = new File(ssidDir);
        if (dir.exists()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
        } else {
            dir.mkdirs();
        }
        DatabaseInitializer.Initialize(newconf.getSsid());
    }

    private void refreshView(final ProjectConfig newConfig) {
        String newName;
        if (this.oldConfig == null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    TreeHelper.addProjectNode(newConfig.getSsid(), newConfig.getProjectName());
                }
            });
            return;
        }
        String oldName = this.oldConfig.getProjectName();
        if (!oldName.equals(newName = newConfig.getProjectName())) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    TreeHelper.modifyProjectNode(newConfig.getSsid(), newConfig.getProjectName());
                }
            });
        }
        String oldUserName = this.oldConfig.getUserName();
        final String newUserName = newConfig.getUserName();
        if (!newUserName.equals(oldUserName)) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ClientInfo clientInfo = ClientList.getMyInfo();
                    if (clientInfo != null) {
                        clientInfo.setClientName(newUserName);
                        TreeHelper.modifyMemberName(newConfig.getSsid(), clientInfo);
                        Join join = new Join(new NetworkConfig());
                        join.execute();
                    }
                }
            });
        }
    }

    private ProjectConfig save() {
        ProjectConfig newConfig = new ProjectConfig();
        newConfig.setProjectName(this.projectNameTxt.getText().trim());
        newConfig.setUserName(this.userNameTxt.getText().trim());
        newConfig.setSsid(this.ssidTxt.getText().trim());
        newConfig.setMailCheck(this.mailChk.getSelection());
        newConfig.setSmtp(this.smtpTxt.getText().trim());
        newConfig.setSender(this.senderTxt.getText().trim());
        newConfig.setRecipient(this.recipientTxt.getText().trim());
        newConfig.setPrefix(this.prefixTxt.getText().trim());
        newConfig.setCategory(this.categoryTxt.getText().trim());
        newConfig.setPriority(this.priorityTxt.getText().trim());
        newConfig.setAssigned(this.assignedTxt.getText().trim());
        newConfig.setVoteCheck(this.voteChk.getSelection());
        newConfig.setVote(this.voteTxt.getText().trim());
        newConfig.setUntilDeadLineCheck(this.untilDeadLineChk.getSelection());
        newConfig.setUntilDeadLine(this.untilDeadLineTxt.getText().trim());
        newConfig.setFixedSyncCheck(this.fixedSyncChk.getSelection());
        newConfig.setAddress1(this.address1.getText().trim());
        newConfig.setAddress2(this.address2.getText().trim());
        newConfig.setAddress3(this.address3.getText().trim());
        newConfig.setAddress4(this.address4.getText().trim());
        newConfig.setPort(this.port.getText().trim());
        newConfig.setAutoSyncCheck(this.autoSyncChk.getSelection());
        newConfig.setNormalSyncRadio(this.normalSyncRdi.getSelection());
        newConfig.setAppointSyncRadio(this.appointSyncRdi.getSelection());
        if (this.oldConfig == null) {
            ProjectConfigManager.save(newConfig);
        } else {
            ProjectConfigManager.modify(this.oldConfig, newConfig);
        }
        return newConfig;
    }

    private void okEnabled() {
        ProjectConfigDialogValidate validate = new ProjectConfigDialogValidate(this);
        if (this.oldConfig == null) {
            this.getButton(0).setEnabled(validate.validateProjectName(this.projectNameTxt) && validate.validateUserName(this.userNameTxt) && validate.validateSsid(this.ssidTxt) && validate.validatePriority(this.priorityTxt) && validate.validateVote(this.voteChk, this.voteTxt) && validate.validateUntilDeadLine(this.untilDeadLineChk, this.untilDeadLineTxt) && validate.validateSmtp(this.mailChk, this.smtpTxt) && validate.validateSender(this.mailChk, this.senderTxt) && validate.validateRecipient(this.mailChk, this.recipientTxt) && validate.validateAddress(this.fixedSyncChk, this.address1) && validate.validateAddress(this.fixedSyncChk, this.address2) && validate.validateAddress(this.fixedSyncChk, this.address3) && validate.validateAddress(this.fixedSyncChk, this.address4) && validate.validatePort(this.fixedSyncChk, this.port));
        } else {
            this.getButton(0).setEnabled(validate.validateProjectName(this.projectNameTxt) && validate.validateUserName(this.userNameTxt) && validate.validatePriority(this.priorityTxt) && validate.validateVote(this.voteChk, this.voteTxt) && validate.validateUntilDeadLine(this.untilDeadLineChk, this.untilDeadLineTxt) && validate.validateSmtp(this.mailChk, this.smtpTxt) && validate.validateSender(this.mailChk, this.senderTxt) && validate.validateRecipient(this.mailChk, this.recipientTxt) && validate.validateAddress(this.fixedSyncChk, this.address1) && validate.validateAddress(this.fixedSyncChk, this.address2) && validate.validateAddress(this.fixedSyncChk, this.address3) && validate.validateAddress(this.fixedSyncChk, this.address4) && validate.validatePort(this.fixedSyncChk, this.port));
        }
    }
}

