/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.navigator;

import java.util.HashMap;
import java.util.Map;
import jp.valtech.bts.data.Issue;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.ui.navigator.BtsTreeNode;
import jp.valtech.bts.ui.navigator.CategoryNode;
import jp.valtech.bts.ui.navigator.ConflictNode;
import jp.valtech.bts.ui.navigator.DraftNode;
import jp.valtech.bts.ui.navigator.GarbageBoxNode;
import jp.valtech.bts.ui.navigator.MemberListNode;
import jp.valtech.bts.ui.navigator.MemberNode;
import jp.valtech.bts.ui.navigator.ProjectNode;
import jp.valtech.bts.ui.navigator.ReleaseNode;

public class TreeBuilder {
    private BtsTreeNode rootNode = new BtsTreeNode();
    private Map project = new HashMap();

    public ProjectNode addProjectNode(String projectName, String ssid) {
        ProjectNode projectNode = new ProjectNode(this.rootNode, projectName, ssid);
        this.rootNode.addChild(projectNode);
        this.project.put(ssid, projectNode);
        return projectNode;
    }

    public void addIssueNode(String ssid, Issue[] issueList) {
        ProjectNode projectNode = (ProjectNode)this.project.get(ssid);
        if (projectNode == null) {
            throw new IllegalArgumentException("Invalid Project SSID : " + ssid);
        }
        ReleaseNode releaseNode = new ReleaseNode(projectNode);
        projectNode.addChild(releaseNode);
        DraftNode draftNode = new DraftNode(projectNode);
        projectNode.addChild(draftNode);
        ConflictNode confrictNode = new ConflictNode(projectNode);
        projectNode.addChild(confrictNode);
        GarbageBoxNode garbageBoxNode = new GarbageBoxNode(projectNode);
        projectNode.addChild(garbageBoxNode);
        if (issueList == null) {
            return;
        }
        int idx = 0;
        while (idx < issueList.length) {
            if ("G".equals(issueList[idx].getType())) {
                garbageBoxNode.incrementChildCount();
            } else if ("D".equals(issueList[idx].getType())) {
                draftNode.incrementChildCount();
            } else if ("C".equals(issueList[idx].getType())) {
                confrictNode.incrementChildCount();
            } else {
                String category = issueList[idx].getCategory();
                CategoryNode ctgryNode = releaseNode.getCategoryNode(category);
                if (ctgryNode == null) {
                    ctgryNode = new CategoryNode(releaseNode, category);
                    releaseNode.addChild(ctgryNode);
                }
                ctgryNode.incrementChildCount();
            }
            ++idx;
        }
    }

    public void addMemberListNode(String ssid, ClientInfo[] clientInfoList) {
        ProjectNode projectNode = (ProjectNode)this.project.get(ssid);
        if (projectNode == null) {
            throw new IllegalArgumentException("Invalid Project SSID : " + ssid);
        }
        MemberListNode memberListNode = new MemberListNode(projectNode);
        projectNode.addChild(memberListNode);
        int idx = 0;
        while (idx < clientInfoList.length) {
            memberListNode.addChild(new MemberNode(memberListNode, clientInfoList[idx]));
            ++idx;
        }
    }

    public BtsTreeNode getRootNode() {
        return this.rootNode;
    }
}

