/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.ui.navigator;

import jp.valtech.bts.data.Issue;
import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.navigator.BtsTreeNode;
import jp.valtech.bts.ui.navigator.CategoryNode;
import jp.valtech.bts.ui.navigator.ConflictNode;
import jp.valtech.bts.ui.navigator.DraftNode;
import jp.valtech.bts.ui.navigator.GarbageBoxNode;
import jp.valtech.bts.ui.navigator.MemberListNode;
import jp.valtech.bts.ui.navigator.ProjectNode;
import jp.valtech.bts.ui.navigator.ReleaseNode;
import org.eclipse.jface.viewers.TreeViewer;

public class TreeHelper {
    public static void modifyProjectNode(String ssid, String projectName) {
        TreeViewer treeViewer = BtsPlugin.getInstance().getNavigatorView().getViewer();
        BtsTreeNode rootNode = (BtsTreeNode)treeViewer.getInput();
        ProjectNode projectNode = (ProjectNode)rootNode.getChild(ssid);
        projectNode.setTextName(projectName);
        treeViewer.refresh((Object)projectNode);
    }

    public static void addProjectNode(String ssid, String projectName) {
        TreeViewer treeViewer = BtsPlugin.getInstance().getNavigatorView().getViewer();
        BtsTreeNode rootNode = (BtsTreeNode)treeViewer.getInput();
        ProjectNode projectNode = new ProjectNode(rootNode, projectName, ssid);
        rootNode.addChild(projectNode);
        treeViewer.add((Object)rootNode, (Object)projectNode);
    }

    public static void openProjectNode(String ssid) {
        TreeViewer treeViewer = BtsPlugin.getInstance().getNavigatorView().getViewer();
        BtsTreeNode rootNode = (BtsTreeNode)treeViewer.getInput();
        ProjectNode projectNode = (ProjectNode)rootNode.getChild(ssid);
        projectNode.open();
        treeViewer.update((Object)projectNode, null);
    }

    public static void closeProjectNode(String ssid) {
        TreeViewer treeViewer = BtsPlugin.getInstance().getNavigatorView().getViewer();
        BtsTreeNode rootNode = (BtsTreeNode)treeViewer.getInput();
        ProjectNode projectNode = (ProjectNode)rootNode.getChild(ssid);
        projectNode.close();
        treeViewer.update((Object)projectNode, null);
        treeViewer.refresh();
        treeViewer.collapseAll();
    }

    public static void deleteProjectNode(String ssid) {
        TreeViewer treeViewer = BtsPlugin.getInstance().getNavigatorView().getViewer();
        BtsTreeNode rootNode = (BtsTreeNode)treeViewer.getInput();
        ProjectNode projectNode = (ProjectNode)rootNode.getChild(ssid);
        rootNode.removeChild(projectNode);
        treeViewer.remove((Object)projectNode);
    }

    public static void modifyMemberName(String ssid, ClientInfo clientInfo) {
        TreeViewer treeViewer = BtsPlugin.getInstance().getNavigatorView().getViewer();
        BtsTreeNode rootNode = (BtsTreeNode)treeViewer.getInput();
        ProjectNode projectNode = (ProjectNode)rootNode.getChild(ssid);
        MemberListNode memberListNode = projectNode.getMemberListNode();
        BtsTreeNode membernode = memberListNode.getChild(clientInfo.getClientAddress());
        if (membernode != null) {
            membernode.setTextName(clientInfo.getClientName());
            treeViewer.refresh((Object)memberListNode);
        }
    }

    public static void incrementIssueCount(Issue issue, ProjectNode projectNode) {
        if ("D".equals(issue.getType())) {
            DraftNode draftNode = projectNode.getDraftNode();
            draftNode.incrementChildCount();
            return;
        }
        if ("C".equals(issue.getType())) {
            ConflictNode conflictNode = projectNode.getConflictNode();
            conflictNode.incrementChildCount();
            return;
        }
        if ("G".equals(issue.getType())) {
            GarbageBoxNode garbageBoxNode = projectNode.getGarbageBoxNode();
            garbageBoxNode.incrementChildCount();
            return;
        }
        ReleaseNode releaseNode = projectNode.getReleaseNode();
        CategoryNode ctgryNode = releaseNode.getCategoryNode(issue.getCategory());
        if (ctgryNode == null) {
            ctgryNode = new CategoryNode(releaseNode, issue.getCategory());
            releaseNode.addChild(ctgryNode);
        }
        ctgryNode.incrementChildCount();
    }

    public static void decrementIssueCount(Issue issue, ProjectNode projectNode) {
        if ("D".equals(issue.getType())) {
            DraftNode draftNode = projectNode.getDraftNode();
            draftNode.decrementChildCount();
            return;
        }
        if ("C".equals(issue.getType())) {
            ConflictNode conflictNode = projectNode.getConflictNode();
            conflictNode.decrementChildCount();
            return;
        }
        if ("G".equals(issue.getType())) {
            GarbageBoxNode garbageBoxNode = projectNode.getGarbageBoxNode();
            garbageBoxNode.decrementChildCount();
            return;
        }
        ReleaseNode releaseNode = projectNode.getReleaseNode();
        CategoryNode ctgryNode = releaseNode.getCategoryNode(issue.getCategory());
        if (ctgryNode != null) {
            ctgryNode.decrementChildCount();
        }
    }
}

