/*
 * Decompiled with CFR 0.152.
 */
package jp.valtech.bts.util;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import jp.valtech.bts.ui.BtsPlugin;

public class CipherUtility {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String KEY_ALGORITHM_TYPE_AES = "AES";
    public static final String KEY_ALGORITHM_TYPE_DES = "DES";
    public static final String KEY_ALGORITHM_TYPE_SHA1 = "SHA1";
    public static final byte ENCRYPT_MODE = 1;
    public static final byte DECRYPT_MODE = 2;

    public static byte[] encrypt(byte[] target, String key) throws InvalidKeyException, IllegalStateException, GeneralSecurityException {
        return CipherUtility.crypt((byte)1, target, key.getBytes(), KEY_ALGORITHM_TYPE_DES);
    }

    public static byte[] decrypt(byte[] target, String key) throws InvalidKeyException, GeneralSecurityException, IllegalStateException {
        return CipherUtility.crypt((byte)2, target, key.getBytes(), KEY_ALGORITHM_TYPE_DES);
    }

    private static byte[] crypt(byte mode, byte[] target, byte[] pkey, String algorithm) throws InvalidKeyException, GeneralSecurityException, IllegalStateException {
        byte[] result = null;
        pkey = CipherUtility.hash(pkey).getBytes();
        SecretKey key = CipherUtility.createDESCryptKey(pkey, algorithm);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init((int)mode, key);
        result = cipher.doFinal(target);
        return result;
    }

    private static SecretKey createDESCryptKey(byte[] b, String algorithm) throws InvalidKeyException, GeneralSecurityException {
        DESKeySpec keySpec = new DESKeySpec(b);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
        return keyFactory.generateSecret(keySpec);
    }

    public static String hash(String target) {
        String result = null;
        try {
            result = CipherUtility.hash(target, KEY_ALGORITHM_TYPE_SHA1);
        }
        catch (NoSuchAlgorithmException e) {
            BtsPlugin.getInstance().errorlog(e);
        }
        return result;
    }

    private static String hash(String target, String algorithm) throws NoSuchAlgorithmException {
        return CipherUtility.hash(target.getBytes(), algorithm);
    }

    public static String hash(byte[] target) {
        String result = null;
        try {
            result = CipherUtility.hash(target, KEY_ALGORITHM_TYPE_SHA1);
        }
        catch (NoSuchAlgorithmException e) {
            BtsPlugin.getInstance().errorlog(e);
        }
        return result;
    }

    private static String hash(byte[] target, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(target);
        byte[] b = md.digest();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            sb.append(HEX[CipherUtility.byte2int(b[i]) / 16]);
            sb.append(HEX[CipherUtility.byte2int(b[i]) % 16]);
            ++i;
        }
        return sb.toString();
    }

    private static int byte2int(byte b) {
        if (b < 0) {
            return b + 256;
        }
        return b;
    }
}

