/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

/**
 * 
 * 課題票に設定する「課題票種別」定数を定義したEnumクラスです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public final class IssueAttribute {
	
	/** 説明 */
	private String description;
	/** 値 */
	private String value;
	
	/** 課題票属性： カテゴリ */
	public static final String CATEGORY_VALUE 	= Messages.getString("IssueAttribute.0"); //$NON-NLS-1$
	/** 課題票属性： タイトル */
	public static final String TITLE_VALUE 		= Messages.getString("IssueAttribute.1"); //$NON-NLS-1$
	/** 課題票属性： 詳細 */
	public static final String DESCRIPTION_VALUE= Messages.getString("IssueAttribute.2"); //$NON-NLS-1$
	/** 課題票属性： 優先度 */
	public static final String PRIORITY_VALUE 	= Messages.getString("IssueAttribute.3"); //$NON-NLS-1$
	/** 課題票属性： ステータス */
	public static final String STATUS_VALUE 	= Messages.getString("IssueAttribute.4"); //$NON-NLS-1$
	/** 課題票属性： 担当者 */
	public static final String ASSIGNED_VALUE 	= Messages.getString("IssueAttribute.5"); //$NON-NLS-1$
	/** 課題票属性： 完了期限 */
	public static final String DEADLINE_VALUE 	= Messages.getString("IssueAttribute.6"); //$NON-NLS-1$
	/** 課題票属性： 内緒のバグ */
	public static final String SECRETBUG_VALUE 	= Messages.getString("IssueAttribute.7"); //$NON-NLS-1$
	/** 課題票属性： 一時保留 */
	public static final String SUSPEND_VALUE 	= Messages.getString("IssueAttribute.8"); //$NON-NLS-1$
	/** 課題票属性： 添付ファイル */
	public static final String ATTACHMENT_VALUE = Messages.getString("IssueAttribute.9"); //$NON-NLS-1$
	/** 課題票属性： コメント */
	public static final String COMMENT_VALUE = Messages.getString("IssueAttribute.10"); //$NON-NLS-1$


	/** 課題票属性： カテゴリ */
	public static final IssueAttribute CATEGORY 	= new IssueAttribute(CATEGORY_VALUE, CATEGORY_VALUE);
	/** 課題票属性： タイトル */
	public static final IssueAttribute TITLE 		= new IssueAttribute(TITLE_VALUE, TITLE_VALUE);
	/** 課題票属性： 詳細 */
	public static final IssueAttribute DESCRIPTION 	= new IssueAttribute(DESCRIPTION_VALUE, DESCRIPTION_VALUE);
	/** 課題票属性： 優先度 */
	public static final IssueAttribute PRIORITY 	= new IssueAttribute(PRIORITY_VALUE, PRIORITY_VALUE);
	/** 課題票属性： ステータス */
	public static final IssueAttribute STATUS 		= new IssueAttribute(STATUS_VALUE, STATUS_VALUE);
	/** 課題票属性： 担当者 */
	public static final IssueAttribute ASSIGNED 	= new IssueAttribute(ASSIGNED_VALUE, ASSIGNED_VALUE);
	/** 課題票属性： 完了期限 */
	public static final IssueAttribute DEADLINE 	= new IssueAttribute(DEADLINE_VALUE, DEADLINE_VALUE);
	/** 課題票属性： 内緒のバグ */
	public static final IssueAttribute SECRETBUG 	= new IssueAttribute(SECRETBUG_VALUE, SECRETBUG_VALUE);
	/** 課題票属性： 一時保留 */
	public static final IssueAttribute SUSPEND 		= new IssueAttribute(SUSPEND_VALUE, SUSPEND_VALUE);
	/** 課題票属性： 添付ファイル */
	public static final IssueAttribute ATTACHMENT 	= new IssueAttribute(ATTACHMENT_VALUE, ATTACHMENT_VALUE);
	/** 課題票属性： コメント */
	public static final IssueAttribute COMMENT 	= new IssueAttribute(COMMENT_VALUE, COMMENT_VALUE);


	
	/**
	 * 外部からは呼ばれません。
	 * 
	 * @param		value			値
	 * @param		description		説明（VALUEと同じ）
	 */
	private IssueAttribute(String value, String description) {
		this.value = value;
		this.description = description;
	}
	
	
	/**
	 * IssueTypeクラスで持つIssueTypeインスタンスの配列を取得します。
	 * 
	 * @return		IssueTypeクラスで持つIssueTypeインスタンスの配列
	 */
	public static IssueAttribute[] getEnums() {
		
		// IssueTypeクラスに持つ定数インスタンスの配列を生成して返す
		return new IssueAttribute[]{ IssueAttribute.CATEGORY
							    , IssueAttribute.TITLE
								, IssueAttribute.DESCRIPTION
								, IssueAttribute.PRIORITY
								, IssueAttribute.STATUS
								, IssueAttribute.ASSIGNED
								, IssueAttribute.DEADLINE
								, IssueAttribute.SECRETBUG
								, IssueAttribute.SUSPEND
								, IssueAttribute.ATTACHMENT
								, IssueAttribute.COMMENT
							  	} ;
	}
	

	/**
	 * 指定された値を持つIssueTypeインスタンスを返します。
	 * 
	 * @param		value			値
	 * @return		IssueTypeインスタンス
	 */
	public static IssueAttribute getEnumByValue(String value) {
		if(value ==null) {
			throw new IllegalArgumentException("Invalid IssueAttribute-value : null");
		}

		// IssueTypeの配列を取得
		IssueAttribute[] issueType = IssueAttribute.getEnums();
		for (int idx = 0; idx < issueType.length; idx++) {
			
			// 引数の値と同一のIssueTypeがある場合はそれを返す
			if( value.equals(issueType[idx].getValue()) ){ 
				return issueType[idx];
			}
		}
		
		// 引数の値と同一のIssueTypeがなかった場合は例外を投げる
		throw new IllegalArgumentException("Invalid IssueAttribute-value : " + value);
	}


	/**
	 * 指定された説明を持つIssueTypeインスタンスを返します。
	 * 
	 * @param		description			説明
	 * @return		IssueTypeインスタンス
	 */
	public static IssueAttribute getEnumByDescription(String description) {
		if(description ==null) {
			throw new IllegalArgumentException("Invalid IssueAttribute-value : null");
		}

		// IssueTypeの配列を取得
		IssueAttribute[] issueType = IssueAttribute.getEnums();
		for (int idx = 0; idx < issueType.length; idx++) {
			
			// 引数の値と同一のIssueTypeがある場合はそれを返す
			if( description.equals(issueType[idx].getDescription()) ){ 
				return issueType[idx];
			}
		}
		
		// 引数の値と同一のIssueTypeがなかった場合は例外を投げる
		throw new IllegalArgumentException("Invalid IssueAttribute-value : " + description);
	}

	/**
	 * 説明を返します。
	 * 
	 * @return		説明
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * 値を返します。
	 * 
	 * @return		値
	 */
	public String getValue() {
		return value;
	}
}
