/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

import java.io.Serializable;
import java.util.Date;

/**
 * <dl><dt><b>課題票履歴</b></dt>
 * 	<dd></dd>
 * </dl>
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class IssueHistory implements Serializable {

	/** シリアルID　*/
	private static final long serialVersionUID = 7274918799052547464L;
	
	public static final String ISSUE_INITIAL_REGIST = Messages.getString("IssueHistory.0"); //$NON-NLS-1$
	public static final String ISSUE_NON_UPDATE = Messages.getString("IssueHistory.1"); //$NON-NLS-1$
	public static final String ISSUE_MOVE_GARBAGE = Messages.getString("IssueHistory.2"); //$NON-NLS-1$
	/** FingerPrint */
	private String fingerPrint = "";
	
	/** 課題票の種別 */
	private String type = "";

	/** 更新した属性名 */
	private String updateAttribute = "";
	
	/** 更新前の情報 */
	private String updateBefore = "";

	/** 更新後の情報 */
	private String updateAfter = "";

	/** 更新者 */
	protected String updateUser = "";

	/** 更新タイムスタンプ  */
	protected Date updateDate = null;


	/**
	 * 課題票履歴を生成します。
	 */
	public IssueHistory() {
		;
	}
	
	/**
	 * 指定の情報で課題票履歴を生成します。
	 * 
	 * @param		issue				課題票				
	 * @param		updateAttribute		変更した属性
	 * @param		updateBefore		変更前
	 * @param		updateAfter			変更後
	 */
	public IssueHistory(Issue issue, String updateAttribute, String updateBefore, String updateAfter) {
		this.fingerPrint = issue.getFingerPrint();
		this.type = issue.getType();
		this.updateAttribute = updateAttribute;
		this.updateBefore = updateBefore;
		this.updateAfter = updateAfter;
		this.updateUser = CurrentProject.getInsance().getProjectConfig().getUserName();
		this.updateDate = issue.getUpdateDate();
	}

	/**
	 * <DL>
	 * <DT><B>レコード更新者 を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * @return レコード更新者 
	 */
	public String getUpdateUser() {
		return this.updateUser;
	}

	/**
	 * <DL>
	 * <DT><B>レコード更新者を設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param updateUser レコード更新者
	 */
	public void setUpdateUser( String updateUser ) {
		this.updateUser = updateUser;
	}

	public String getFingerPrint() {
		return fingerPrint;
	}

	public void setFingerPrint(String fingerPrint) {
		this.fingerPrint = fingerPrint;
	}
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getUpdateAfter() {
		return updateAfter;
	}

	public void setUpdateAfter(String updateAfter) {
		this.updateAfter = updateAfter;
	}

	public String getUpdateAttribute() {
		return updateAttribute;
	}

	public void setUpdateAttribute(String updateAtrribute) {
		this.updateAttribute = updateAtrribute;
	}

	public String getUpdateBefore() {
		return updateBefore;
	}

	public void setUpdateBefore(String updateBefore) {
		this.updateBefore = updateBefore;
	}

	
	/**
	 * <DL>
	 *  <DT><B>日時情報を設定します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param updateDate        日時オブジェクト
	 */
	public void setUpdateDate( Date updateDate ){
		if( updateDate != null ){
			this.updateDate = new Date( updateDate.getTime() );
		}
	}

	/**
	 * <DL>
	 *  <DT><B>日時情報をlong型のタイムスタンプで設定します。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @param timestamp   ong型のタイムスタンプ
	 */
	public void setUpdateDate( long timestamp ){
		this.updateDate = new Date( timestamp );
	}

	/**
	 * <DL>
	 *  <DT><B>タイムスタンプ を取得。</B></DL>
	 *  <DD></DD>
	 * </DL>
	 * @return タイムスタンプ
	 */
	public Date getUpdateDate(){
		return this.updateDate;
	}

	/**
	 * <DL>
	 *  <DT><B>longのタイムスタンプで取得</B></DL>
	 *  <DD>日付情報をlongのタイムスタンプで取得します。
	 * </DL>
	 * @return タイムスタンプ(long)
	 */
	public long getUpdateDateTimestamp(){
		return this.updateDate.getTime();
	}



}