/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

/**
 * 
 * 課題票に設定する「ステータス」定数を定義したEnumクラスです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public final class IssueStatus {
	
	/** 説明 */
	private String description;
	/** 値 */
	private String value;
	
	/** 起票 */
	public static final String OPENED_VALUE 	= "1";
	/** 担当者アサイン */
	public static final String ASSIGNED_VALUE 	= "2"; 
	/** 対応済み */
	public static final String RESOLVED_VALUE 	= "3";
	/** 確認済み */
	public static final String VERIFIED_VALUE 	= "4";
	/** 完了 */
	public static final String CLOSED_VALUE 	= "5";

	
	/** 起票 */
	public static final IssueStatus OPENED 		= new IssueStatus(OPENED_VALUE,   Messages.getString("IssueStatus.0")); //$NON-NLS-1$
	/** 担当者アサイン */
	public static final IssueStatus ASSIGNED 	= new IssueStatus(ASSIGNED_VALUE, Messages.getString("IssueStatus.1")); //$NON-NLS-1$
	/** 対応済み */
	public static final IssueStatus RESOLVED 	= new IssueStatus(RESOLVED_VALUE, Messages.getString("IssueStatus.2")); //$NON-NLS-1$
	/** 確認済み */
	public static final IssueStatus VERIFIED 	= new IssueStatus(VERIFIED_VALUE, Messages.getString("IssueStatus.3")); //$NON-NLS-1$
	/** 完了 */
	public static final IssueStatus CLOSED 		= new IssueStatus(CLOSED_VALUE,   Messages.getString("IssueStatus.4")); //$NON-NLS-1$

	
	/**
	 * 外部からは呼ばれません。
	 * 
	 * @param		value			値
	 * @param		description		説明
	 */
	private IssueStatus(String value, String description) {
		this.value = value;
		this.description = description;
	}
	
	
	/**
	 * IssueStatusクラスで持つIssueStatusインスタンスの配列を取得します。
	 * 
	 * @return		IssueStatusクラスで持つIssueStatusインスタンスの配列
	 */
	public static IssueStatus[] getEnums() {
		
		// IssueStatusクラスに持つ定数インスタンスの配列を生成して返す
		return new IssueStatus[]{ IssueStatus.OPENED
							    , IssueStatus.ASSIGNED
								, IssueStatus.RESOLVED
								, IssueStatus.VERIFIED
								, IssueStatus.CLOSED
							  	} ;
	}
	

	/**
	 * 指定された値を持つIssueStatusインスタンスを返します。
	 * 
	 * @param		value			値
	 * @return		IssueStatusインスタンス
	 */
	public static IssueStatus getEnumFromValue(String value) {
		if(value ==null) {
			throw new IllegalArgumentException("Invalid IssueStatus-value : null");
		}

		// IssueStatusの配列を取得
		IssueStatus[] issueStatus = IssueStatus.getEnums();
		for (int idx = 0; idx < issueStatus.length; idx++) {
			
			// 引数の値と同一のIssueStatusがある場合はそれを返す
			if( value.equals(issueStatus[idx].getValue()) ){ 
				return issueStatus[idx];
			}
		}
		
		// 引数の値と同一のIssueStatusがなかった場合は例外を投げる
		throw new IllegalArgumentException("Invalid IssueStatus-value : " + value);
	}


	/**
	 * 指定された説明を持つIssueStatusインスタンスを返します。
	 * 
	 * @param		description			説明
	 * @return		IssueStatusインスタンス
	 */
	public static IssueStatus getEnumByDescription(String description) {
		if(description ==null) {
			throw new IllegalArgumentException("Invalid IssueStatus-value : null");
		}

		// IssueStatusの配列を取得
		IssueStatus[] issueStatus = IssueStatus.getEnums();
		for (int idx = 0; idx < issueStatus.length; idx++) {
			
			// 引数の値と同一のIssueStatusがある場合はそれを返す
			if( description.equals(issueStatus[idx].getDescription()) ){ 
				return issueStatus[idx];
			}
		}
		
		// 引数の値と同一のIssueStatusがなかった場合は例外を投げる
		throw new IllegalArgumentException("Invalid IssueStatus-value : " + description);
	}

	/**
	 * 説明を返します。
	 * 
	 * @return		説明
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * 値を返します。
	 * 
	 * @return		値
	 */
	public String getValue() {
		return value;
	}
}
