/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

/**
 * 
 * 課題票に設定する「課題票種別」定数を定義したEnumクラスです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public final class IssueType {
	
	/** 説明 */
	private String description;
	/** 値 */
	private String value;
	
	/** 課題票：正規版 */
	public static final String RELEASE_VALUE 	= "R";
	/** 課題票：競合 */
	public static final String CONFLICT_VALUE 	= "C"; 
	/** 課題票：下書き */
	public static final String DRAFT_VALUE		= "D";
	/** 課題票：ゴミ箱 */
	public static final String GARBAGE_VALUE 	= "G";

	
	/** 課題票：正規版 */
	public static final IssueType RELEASE 	= new IssueType(RELEASE_VALUE,  Messages.getString("IssueType.0")); //$NON-NLS-1$
	/** 課題票：競合 */
	public static final IssueType CONFLICT 	= new IssueType(CONFLICT_VALUE, Messages.getString("IssueType.1")); //$NON-NLS-1$
	/** 課題票：下書き */
	public static final IssueType DRAFT 	= new IssueType(DRAFT_VALUE, 	Messages.getString("IssueType.2")); //$NON-NLS-1$
	/** 課題票：ゴミ箱 */
	public static final IssueType GARBAGE 	= new IssueType(GARBAGE_VALUE,	Messages.getString("IssueType.3")); //$NON-NLS-1$

	
	/**
	 * 外部からは呼ばれません。
	 * 
	 * @param		value			値
	 * @param		description		説明
	 */
	private IssueType(String value, String description) {
		this.value = value;
		this.description = description;
	}
	
	
	/**
	 * IssueTypeクラスで持つIssueTypeインスタンスの配列を取得します。
	 * 
	 * @return		IssueTypeクラスで持つIssueTypeインスタンスの配列
	 */
	public static IssueType[] getEnums() {
		
		// IssueTypeクラスに持つ定数インスタンスの配列を生成して返す
		return new IssueType[]{ IssueType.RELEASE
							   , IssueType.CONFLICT
							   , IssueType.DRAFT
							   , IssueType.GARBAGE
							   } ;
	}
	

	/**
	 * 指定された値を持つIssueTypeインスタンスを返します。
	 * 
	 * @param		value			値
	 * @return		IssueTypeインスタンス
	 */
	public static IssueType getEnumByValue(String value) {
		if(value ==null) {
			throw new IllegalArgumentException("Invalid IssueType-value : null");
		}

		// IssueTypeの配列を取得
		IssueType[] issueType = IssueType.getEnums();
		for (int idx = 0; idx < issueType.length; idx++) {
			
			// 引数の値と同一のIssueTypeがある場合はそれを返す
			if( value.equals(issueType[idx].getValue()) ){ 
				return issueType[idx];
			}
		}
		
		// 引数の値と同一のIssueTypeがなかった場合は例外を投げる
		throw new IllegalArgumentException("Invalid IssueType-value : " + value);
	}


	/**
	 * 指定された説明を持つIssueTypeインスタンスを返します。
	 * 
	 * @param		description			説明
	 * @return		IssueTypeインスタンス
	 */
	public static IssueType getEnumByDescription(String description) {
		if(description ==null) {
			throw new IllegalArgumentException("Invalid IssueType-value : null");
		}

		// IssueTypeの配列を取得
		IssueType[] issueType = IssueType.getEnums();
		for (int idx = 0; idx < issueType.length; idx++) {
			
			// 引数の値と同一のIssueTypeがある場合はそれを返す
			if( description.equals(issueType[idx].getDescription()) ){ 
				return issueType[idx];
			}
		}
		
		// 引数の値と同一のIssueTypeがなかった場合は例外を投げる
		throw new IllegalArgumentException("Invalid IssueType-value : " + description);
	}

	/**
	 * 説明を返します。
	 * 
	 * @return		説明
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * 値を返します。
	 * 
	 * @return		値
	 */
	public String getValue() {
		return value;
	}
}
