/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.data;

import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.ui.preference.BtsPreference;


/**
 * <dl><dt><b>ネットワーク設定情報</b></dt>
 * 	<dd>
 *   ネットワークの情報は、インスタンス生成時に取得しその後変更不可となります。<br>
 *   したがって、ユーザ操作で「設定ダイアログ」を使ってネットワーク情報を変更した場合、それを反映させるには
 *   「プロジェクトを閉じる」→「プロジェクトを開く」という操作を行う必要があります。
 *   </dd>
 * </dl>
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class NetworkConfig{

	/** カレントプロジェクトの設定情報 */
	private ProjectConfig prjctConf = CurrentProject.getInsance().getProjectConfig();

	/** マルチキャスト通信で使うポート番号 */
	private int multicastPort = -1;
	
	/** マルチキャスト通信で使うIPアドレス */
	private String multicastAddress = "";
	
	/** TCP通信で使うポート番号 */
	private int tcpPort = -1;

	/** 配信処理のタイムアウト（秒） */
	private int sendTimeout = 10 * 1000;
	
	/** 同期処理のタイムアウト（秒） */
	private int syncTimeout = 25 * 1000;
	
	/**
	 * ネットワーク情報生成。
	 *
	 */
	public NetworkConfig() {

		// パースペクティブ設定情報取得
		BtsPreference preference = BtsPreference.getInstance();

		// ネットワーク情報設定
		multicastPort 	= preference.getMulticastPort();
		multicastAddress= preference.getMulticastAddress();
		tcpPort 		= preference.getTCPPort();
		sendTimeout 	= preference.getSendTimeout();
		syncTimeout		= preference.getSyncTimeout();
	}
	
	
	/**
	 * <DL>
	 * <DT><B>セキュリティID を戻します。</B></B>
	 * <DD>カレントプロジェクトに設定されているプロジェクトのSSIDを返します。</DD>
	 * </DL>
	 * 
	 * @return セキュリティID
	 */
	public String getSSID() {
		return prjctConf.getSsid();
	}


	/**
	 * <DL>
	 * <DT><B>マルチキャストポート番号 を戻します。</B></B>
	 * <DD>マルチキャストポート番号をIntegerのプリミティブ型intで取得します。</DD>
	 * </DL>
	 * 
	 * @return マルチキャストポート番号
	 */
	public int getMulticastPort() {
		return multicastPort;
	}


	/**
	 * <DL>
	 * <DT><B>マルチキャストアドレス を戻します。</B></B>
	 * <DD></DD>
	 * </DL>
	 * 
	 * @return マルチキャストアドレス
	 */
	public String getMulticastAddress() {
		return multicastAddress;
	}


	/**
	 * <DL>
	 * <DT><B>TCPデータ通信ポート番号 を戻します。</B></B>
	 * <DD>TCPデータ通信ポート番号をIntegerのプリミティブ型intで取得します。</DD>
	 * </DL>
	 * 
	 * @return TCPデータ通信ポート番号
	 */
	public int getTCPPort() {
		return tcpPort;
	}

	


	/**
	 * 配信処理のタイムアウト（秒）を設定します。
	 * 
	 * @return		配信処理のタイムアウト（秒）
	 */
	public int getSendTimeout() {
		return sendTimeout;
	}


	/**
	 * 同期処理のタイムアウト（秒）を設定します。
	 * 
	 * @return		同期処理のタイムアウト（秒）
	 */
	public int getSyncTimeout() {
		return syncTimeout;
	}

}