/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.network;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <dl><dt><b>送受信データ基底クラス</b></dt>
 * <dd>
 * 	送受信されるデータの基底クラスです。<br>
 * 	このクラスを継承した{@link jp.valtech.bts.network.Request}または、{@link jp.valtech.bts.network.Response}をそれぞれ目的に応じて使用してください。
 * </dd>
 * </dl>
 * 
 * @author		<A href="mailto:iinuma@valtech.jp">K.Iinuma</A>
 * @version	Ver.0.8
 */
public abstract class TransData implements Serializable {

	/** リクエストパラメータ */
	protected Map		parameters		= null;

	/**
	 * <DL><DT><B>リクエストパラメータ を戻します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @return parameters	リクエストパラメータ 
	 */
	public Map getParameters() {
		return this.parameters;
	}

	/**
	 * <DL><DT><B>リクエストパラメータを設定します。</B></DT>
	 * <DD></DD>
	 * </DL>
	 * @param parameters リクエストパラメータ。
	 */
	public void setParameters( Map parameters ) {
		this.parameters = parameters;
	}

	/**
	 * <DL><DT><B>設定したパラメータを取得します。</B></DT>
	 *  <DD>キーに対応するオブジェクトがない場合はnullになります。</DD>
	 * </DL>
	 * @param			key			パラメータ取得のキー文字列
	 * @return			Object型のパラメータ
	 */
	public Object getParameterObject( String key ){
		Object result = null;

		if( ( this.parameters != null ) && ( this.parameters.containsKey( key ) ) ){
			result = this.parameters.get( key );
		}

		return result;
	}

	/**
	 * <DL><DT><B>設定したパラメータを取得します。</B></DT>
	 *  <DD>パラメータがNumber型もしくはその派生クラスでない場合、キーに対応するオブジェクトがない場合はnullになります。</DD>
	 * </DL>
	 * @param			key			パラメータ取得のキー文字列
	 * @return			Number型のパラメータ
	 */
	public Number getParameterNumber( String key ){
		Number result = null;

		Object obj = getParameterObject( key );

		if( obj instanceof Number ){
			result = (Number)obj;
		}

		return result;
	}

	
	/**
	 * <DL><DT><B>設定したパラメータを取得します。</B></DT>
	 *  <DD>パラメータがBoolean型もしくはその派生クラスでない場合、キーに対応するオブジェクトがない場合はnullになります。</DD>
	 * </DL>
	 * @param			key			パラメータ取得のキー文字列
	 * @return			Boolean型のパラメータ
	 */
	public Boolean getParameterBoolean( String key ){
		Boolean result = null;

		Object obj = getParameterObject( key );

		if( obj instanceof Boolean ){
			result = (Boolean)obj;
		}

		return result;
	}

	/**
	 * <DL><DT><B>設定したパラメータを取得します。</B></DT>
	 *  <DD>パラメータがDate型もしくはその派生クラスでない場合、キーに対応するオブジェクトがない場合はnullになります。</DD>
	 * </DL>
	 * @param			key			パラメータ取得のキー文字列
	 * @return			Date型のパラメータ
	 */
	public Date getParameterDate( String key ){
		Date result = null;

		Object obj = getParameterObject( key );

		if( obj instanceof Date ){
			result = (Date)obj;
		}

		return result;
	}

	/**
	 * <DL><DT><B>設定したパラメータを取得します。</B></DT>
	 *  <DD>パラメータがString型もしくはその派生クラスでない場合、キーに対応するオブジェクトがない場合はnullになります。</DD>
	 * </DL>
	 * @param			key			パラメータ取得のキー文字列
	 * @return			String型のパラメータ
	 */
	public String getParameterString( String key ){
		String result = null;
		Object obj = getParameterObject( key );

		if( obj instanceof String ){
			result = (String)obj;
		}

		return result;
	}

	/**
	 * <DL><DT>パラメータを追加します。<B></B></DT>
	 *  <DD>{@link Object}型オブジェクトのパラメータを設定します。</DD>
	 * </DL>
	 * @param		key			パラメータ設定のキー文字列
	 * @param		map			パラメータ本体
	 */
	public void addParameter( String key, Object object ){
		if( this.parameters == null ){
			this.parameters = new HashMap();
		}
		this.parameters.put( key, object );
	}

}
