/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui;

/**
 * BTS共通のエラークラスです。
 * {@link java.lang.Exception}を親クラスに持ちます。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class BtsException  extends Exception {


	/** このクラスのSerialVersionUID */
	private static final long serialVersionUID = 4601283076675669303L;

	/**
	 * 何もしません。
	 */
	public BtsException() {
    	super();
	}

    /**
     * {@link java.lang.Throwable}をわたします。
     * @param			cause					Throwable
     */
    public BtsException(Throwable cause) {
    	super(cause);
    }

    /**
     * メッセージ文字列を渡します。
     * @param			message
     */
    public BtsException(String message) {
    	super(message);
    }

    /**
     * {@link java.lang.Throwable}とメッセージを渡します。
     * @param			message
     * @param			cause				Throwable
     */
    public BtsException(String message, Throwable cause) {
    	super(message, cause);
    }
}
