/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui;

import java.util.List;

import jp.valtech.bts.data.Issue;
import jp.valtech.bts.data.MessagePacket;
import jp.valtech.bts.network.ClientInfo;

/**
 * BTS情報が更新された際に呼ばれるリスナインタフェースです。
 * 
 * BTS情報とは以下のものをさします。
 * <ul>
 * <li>{@link jp.valtech.bts.data.Issue 課題票}
 * <li>{@link jp.valtech.bts.data.MessagePacket メッセージ} 
 * <li>参加者リスト
 * </ul>
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public interface IBtsListener {

	/**
	 * {@link Issue 課題票}の新規登録処理です。
	 * 
	 * @param		newIssue				新規登録する課題票
	 */
	public void addIssue(Issue newIssue);
	
	
	/**
	 * 登録済みの{@link Issue 課題票}を更新します。
	 * 
	 * @param		oldissue			更新した課題票
	 * @param		newissue			更新した課題票
	 */
	public void updateIssue(Issue oldIssue, Issue newIssue);

	
	/**
	 * 登録済みの{@link Issue 課題票}を削除します。
	 * 
	 * @param		deleteIssue				削除する課題票
	 */
	public void deleteIssue(Issue deleteIssue);

	/**
	 * プロジェクトにメンバ追加
	 * 
	 * @param		clientInfo		追加したメンバ情報
	 */
	public void joinMember(ClientInfo clientInfo);

	
	/**
	 * プロジェクトからメンバ離脱
	 * 
	 * @param		clientInfo		離脱したメンバ情報
	 */
	public void leaveMember(ClientInfo clientInfo);
	
	
	/**
	 * メッセージ追加
	 * 
	 * @param		messagePacket	追加するメッセージ
	 */
	public void addMessage(MessagePacket messagePacket);


	/**
	 * メッセージ削除
	 * 
	 * @param		messagePacket	削除するメッセージ
	 */
	public void deleteMessage(MessagePacket messagePacket);

	
	/**
	 * 現在のローカルDBの情報で画面を再表示します。
	 * 他端末との同期処理は行いません。
	 * 
	 * @param		issueList				課題票を入れたList
	 * 
	 */
	public void refresh(List issueList);
	
	/**
	 * 表示をクリアします。
	 */
	public void clear();
	
	
}
