/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import java.util.List;

import jp.valtech.bts.command.client.Leave;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.network.ClientList;
import jp.valtech.bts.network.server.Server;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.IBtsListener;
import jp.valtech.bts.ui.msglist.MessageListView;
import jp.valtech.bts.ui.navigator.TreeHelper;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;

/**
 * プロジェクトを閉じるアクションです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class CloseProjectAction extends Action {

	/** プロジェクトのSSID */
	private String ssid;

	/**
	 * アクションを生成します。
	 */
	public CloseProjectAction() {
		super();
		setText(Messages.getString("CloseProjectAction.0")); //$NON-NLS-1$
		setToolTipText(Messages.getString("CloseProjectAction.1"));  //$NON-NLS-1$
		setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("project_close.gif"));
	}

	
	/**
	 * プロジェクトを閉じます。。
	 */
	public void run() {

		// サーバプロセスを終了
		Server server = Server.getServer();
		server.stopServer();
		
		// 離脱したことを参加者に伝える
		Leave leave = new Leave( new NetworkConfig() );
		leave.execute();

		// クライアントリストをクリアする。
		ClientList.clear();
		
		// ビューを更新します。
		Display.getDefault().syncExec(new Runnable() {
			public void run() {
				// 当該プロジェクトノードを閉じる。
				TreeHelper.closeProjectNode(ssid);
				
			}
		});

		// 一覧表示をクリアする。
		List listeners = BtsPlugin.getInstance().getListeners();
		for (int idx = 0; idx < listeners.size(); idx++) {
			IBtsListener listnener = (IBtsListener)listeners.get(idx);
			listnener.clear();
		}

		BtsPlugin plugin = BtsPlugin.getInstance();
		
		// メッセージ一覧に表示しているメッセージをクリアする
		MessageListView messageListView = plugin.getMessageView();
		if(messageListView != null) {
			messageListView.getMsgTxt().setText("");
		}
		
		// 開いている課題票エディタを全て閉じる
		BtsPlugin.getInstance().closeAllIssueEditors();
		
		// カレントプロジェクトをクローズする。
		CurrentProject current = CurrentProject.getInsance();
		current.close();
	}

	/**
	 * SSIDを設定します。
	 * @param		ssid			SSID
	 */
	public void setSSID(String ssid) {
		this.ssid = ssid;
	}

}
