/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import java.io.File;

import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.navigator.ProjectConfigManager;
import jp.valtech.bts.ui.navigator.TreeHelper;
import jp.valtech.bts.util.BTSUtility;
import jp.valtech.bts.util.Logging;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

/**
 * プロジェクトを削除するアクションです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class DeleteProjectAction extends Action implements Logging {

	/** プロジェクトのSSID */
	private String ssid;

	/**
	 * 呼び出し元のビューインスタンスを設定します。
	 * 
	 * @param		view			 呼び出し元のビューインスタンス
	 */
	public DeleteProjectAction() {
		super();
		setText(Messages.getString("DeleteProjectAction.0")); //$NON-NLS-1$
		setToolTipText(Messages.getString("DeleteProjectAction.1"));  //$NON-NLS-1$
		setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("delete.gif"));
	}
	
	/**
	 * プロジェクトを削除します。
	 */
	public void run() {
		
		try {
			// 削除確認のダイアログ
			boolean res = MessageDialog.openQuestion
						( BtsPlugin.getInstance().getShell()
						, Messages.getString("DeleteProjectAction.2") //$NON-NLS-1$
						, Messages.getString("DeleteProjectAction.3")); //$NON-NLS-1$

			// 「いいえ」選択時
			if(!res) {
				return;
			}
			
			// 指定したセクションを削除
			ProjectConfigManager.remove(ssid);
			
			// 指定のSSIDがベースとしているディレクトリのPATH文字列を取得
			String baseDir = BTSUtility.getBaseDir(ssid);
			
			// ディレクトリを消す
			File dir = new File(baseDir);
			if( dir.exists() ){
				
				// ディレクトリの中身を全部消す
				File[] files = dir.listFiles();
				for(int i=0; i<files.length; i++) {
					files[i].delete();		
				}
				
				// 空の添付フォルダを削除
				dir.delete();
			}

			// ツリーを更新。
			Display.getDefault().syncExec(new Runnable() {
				public void run() {
					TreeHelper.deleteProjectNode(ssid);
				}
			});
			
		} catch (Exception e) {
			String msg = Messages.getString("DeleteProjectAction.4"); //$NON-NLS-1$
			logger.fatal(msg, e);
			BtsPlugin.getInstance().error(msg, e);
		}
		
	}
	
	/**
	 * SSIDを設定します。
	 * @param		ssid			SSID
	 */
	public void setSSID(String ssid) {
		this.ssid = ssid;
	}
}
