/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.issuelist.IssueFilterDialog;
import jp.valtech.bts.ui.issuelist.IssueListView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * フィルターボタンのアクションです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class OpenIssueFilterDlgAction extends Action {

	/** 活性時のアイコン */
	private static final ImageDescriptor THIS_IMAGE = BtsPlugin.getInstance().getImageDescriptor("filter.gif"); 
	/** 非活性時のアイコン */
	private static final ImageDescriptor THIS_IMAGE_DISABLE = BtsPlugin.getInstance().getImageDescriptor("filter_disable.gif"); 

	/** このアクションが結びつけれれているビューです。 */
	private IssueListView view;
	
	/**
	 * 初期設定。
	 * ビューインスタンスを格納します。
	 * UIを設定します。 
	 */
	public OpenIssueFilterDlgAction(IssueListView view) {
		super();
		this.view = view;
		setText(Messages.getString("OpenIssueFilterDlgAction.0")); //$NON-NLS-1$

		setImageDescriptor(THIS_IMAGE);
		setDisabledImageDescriptor(THIS_IMAGE_DISABLE);
	}

	/**
	 * 課題票フィルタボタンを押したときの動作を設定します。
	 */
	public void run() {

		// フィルター設定のダイアログ表示
		IssueFilterDialog dialog = new IssueFilterDialog(view);
		dialog.open();
	}
}
