/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.network.server.Server;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.issuelist.IssueListView;
import jp.valtech.bts.ui.issuelist.IssueListViewFilter;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.ui.navigator.TreeHelper;
import jp.valtech.bts.util.Logging;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

/**
 * プロジェクトを開くアクションです。。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class OpenProjectAction extends Action implements Logging {


	/** SSID */
	private String ssid="";
	
	
	/**
	 * アクションを生成します。
	 */
	public OpenProjectAction() {
		super();
		setText(Messages.getString("OpenProjectAction.0")); //$NON-NLS-1$
		setToolTipText(Messages.getString("OpenProjectAction.1"));  //$NON-NLS-1$
		setImageDescriptor(BtsPlugin.getInstance().getImageDescriptor("project.gif"));
	}

	
	/**
	 * SSIDを取得します。
	 * @param		ssid		SSID
	 */
	public void setSSID(String ssid) {
		this.ssid = ssid;
	}

	
	/**
	 * 選択したプロジェクトに接続します。
	 */
	public void run() {
		try {
			// カレントプロジェクト取得
			CurrentProject current = CurrentProject.getInsance();

			// カレントプロジェクトが設定されている場合は開くことができない。
			if(current.isOpen()) {
				MessageDialog.openInformation
						( BtsPlugin.getInstance().getShell()
						, Messages.getString("OpenProjectAction.2")  //$NON-NLS-1$
						, Messages.getString("OpenProjectAction.3")); //$NON-NLS-1$

				return ;
			}
			
			// 選択したプロジェクトをカレントプロジェクトに設定します。
			current.setCurrentProject(ssid);

			// サーバプロセスを起動します。
			Server server = Server.getServer();
			server.startServer();

			// 同期処理が正常終了したかどうかのフラグ
			boolean isSyncFinished = false;
			
			ProjectConfig prjctConf = CurrentProject.getInsance().getProjectConfig();
			
			// 起動時に同期を行う
			if(prjctConf.isAutoSyncCheck()) {
				if(prjctConf.isNormalSyncRadio()) {
					// 自動同期処理が「通常の同期」
					SyncRemoteAction syncAction = new SyncRemoteAction();
					syncAction.run();
					isSyncFinished = syncAction.isFinished();
				} else if(prjctConf.isAppointSyncRadio()) {
					// 自動同期処理が「端末を指定した同期」
					SyncSelectionRemoteAction syncAction = new SyncSelectionRemoteAction();
					syncAction.run();
					isSyncFinished = syncAction.isFinished();
				}
			}
			
			// 同期処理が正常終了してない場合は、既存のローカルデータでビューを最新表示にする
			if(!isSyncFinished) {
				// 現在のローカルの情報でビューを最新表示
				RefreshAction refresh = new RefreshAction();
				refresh.run();
			}
			
			// フィルタ実行
			IssueListView view = BtsPlugin.getInstance().getIssueView();
			if(view != null) {
				IssueListViewFilter filter = new IssueListViewFilter(view);
				filter.setClearFilter();
			}
			
			// ビューを操作するので、メインスレッドでの処理を強制します。
			Display.getDefault().syncExec(new Runnable() {
				public void run() {
					// プロジェクトノードのアイコン表示をOPENにします。
					TreeHelper.openProjectNode(ssid);
				}
			});


		} catch (Exception e) {
			String msg = Messages.getString("OpenProjectAction.4"); //$NON-NLS-1$
			logger.fatal(msg, e);
			BtsPlugin.getInstance().error(msg, e);
		}
	}
}
