/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.action;

import jp.valtech.bts.command.client.Ping;
import jp.valtech.bts.command.client.SyncIssue;
import jp.valtech.bts.data.CurrentProject;
import jp.valtech.bts.data.NetworkConfig;
import jp.valtech.bts.ui.BtsPlugin;
import jp.valtech.bts.ui.navigator.ProjectConfig;
import jp.valtech.bts.util.Logging;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * 他の端末と同期をとり、ローカルデータを最新状態にします。
 * 同期相手の端末は、プロジェクト設定画面にて指定します。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class SyncRemoteAction extends Action implements Logging {

	/** 活性時のアイコン */
	private static final ImageDescriptor THIS_IMAGE = BtsPlugin.getInstance().getImageDescriptor("sync1.gif"); 
	/** 非活性時のアイコン */
	private static final ImageDescriptor THIS_IMAGE_DISABLE = BtsPlugin.getInstance().getImageDescriptor("sync1_disable.gif"); 

	/** 同期コマンドが成功したかどうか */
	private boolean finished = false;

	
	/**
	 * 呼び出し元のビューインスタンスを設定します。
	 */
	public SyncRemoteAction() {
		super();
		setText(Messages.getString("SyncRemoteAction.0")); //$NON-NLS-1$
		setToolTipText(Messages.getString("SyncRemoteAction.1"));  //$NON-NLS-1$
		setImageDescriptor(THIS_IMAGE);
		setDisabledImageDescriptor(THIS_IMAGE_DISABLE);
	}

	
	/**
	 * リモート端末と同期をとります。
	 */
	public void run() {

		ProjectConfig config = CurrentProject.getInsance().getProjectConfig();
		if(!config.isFixedSyncCheck()) {
			 MessageDialog.openInformation
				( BtsPlugin.getInstance().getShell()
		        , Messages.getString("SyncRemoteAction.4") //$NON-NLS-1$
		        , Messages.getString("SyncRemoteAction.15")); //$NON-NLS-1$
			 return;
		}

		 // ネットワーク情報生成 
		 String host = config.getSyncAddress();
		 int port = config.getSyncPort();
		 NetworkConfig networkConfig = new NetworkConfig();
		 
		 // 指定の端末が、自端末のカレントプロジェクトと同じプロジェクトがオープンしているかどうか確認する
		 Ping ping = new Ping(networkConfig, host, port);
		 ping.execute();
		 
		 // 指定端末のプロジェクトがオープンしていない場合。終了
		 if(!ping.isSuccessful()) {
			 MessageDialog.openError
				( BtsPlugin.getInstance().getShell()
		        , Messages.getString("SyncRemoteAction.4") //$NON-NLS-1$
		        , ping.getErrorMsg() );
			 return;
		 }
		 
		 
		// ようやく同期処理実行
		SyncIssue syncIssue	= new SyncIssue(networkConfig, host, port);
		syncIssue.setRemoteUserName(Messages.getString("SyncRemoteAction.16")); //$NON-NLS-1$
		syncIssue.execute();
		
		this.finished = syncIssue.isFinished();
	}


	/**
	 * 同期処理の実行結果を取得する。
	 * 
	 * @return			true --同期処理実行成功。
	 * 					false--同期処理実行失敗。
	 */
	public boolean isFinished() {
		return this.finished;
	}
}
