/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.navigator;

import jp.valtech.bts.ui.BtsPlugin;

import org.eclipse.swt.graphics.Image;



/**
 * 参加者ノードを格納するフォルダノードです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class MemberListNode extends BtsTreeNode implements IChildCountNode, ISecondNode, IFolderNode{
    
	/** このノードのイメージファイル */
	private static final Image IMAGE = BtsPlugin.getInstance().getImage("member_list.gif"); 

	/** このノードの表示名 */
	public static final String TEXT_NAME = Messages.getString("MemberListNode.0");  //$NON-NLS-1$

	/** このノードのソートキー */
	private static final String SORT_KEY = "005";

	/**
     * 親ノード・ラベルを設定します。
     * 
     * @param		parent				このノードの親
     */
    public MemberListNode(BtsTreeNode parent) {
    	super(parent, TEXT_NAME, IMAGE);
    }
    
	/**
	 * ソートキーを返します。
	 * 
	 * @return		このノードのソートキー
	 */
	public String getFolderSortKey() {
		return SORT_KEY;
	}

	/*
	 *  (非 Javadoc)
	 * @see jp.valtech.bts.ui.navigator.IChildCountNode#getChildCount()
	 */
	public int getChildCount() {
		return children.size();
	}
	
	/*
	 *  (非 Javadoc)
	 * @see jp.valtech.bts.ui.navigator.BtsTreeNode#compareTo(java.lang.Object)
	 */
	public int compareTo(Object obj) {
		if(obj instanceof MemberListNode) {
			ISecondNode that = (ISecondNode)obj;
			String thisKey = this.getFolderSortKey();
			String thatKey = that.getFolderSortKey();
			return thisKey.compareTo(thatKey);
		}
		return -1;
	}

}
