/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.navigator;

import jp.valtech.bts.network.ClientInfo;
import jp.valtech.bts.ui.BtsPlugin;

import org.eclipse.swt.graphics.Image;



/**
 * プロジェクトに参加中のユーザを表示するノードです。
 * 
 * @author		<A href="mailto:m_sugitou@valtech.jp">M.Sugito</A>
 * @version	Ver.0.8
 */
public class MemberNode extends BtsTreeNode {
    
	/** このノードのイメージファイル */
	private static final Image IMAGE = BtsPlugin.getInstance().getImage("member.gif"); 
	
	/** このノードに参加メンバの情報を保持します */
	private ClientInfo clientInfo;

	/**
     * 親ノード・ラベルを設定します。
     * 
     * @param		parent				このノードの親
     * @param		textName			このノードのラベル
     */
    public MemberNode(BtsTreeNode parent, ClientInfo clientInfo) {
    	super(parent, clientInfo.getClientName(), IMAGE);
    	this.clientInfo = clientInfo;
    }


	/**
	 * 参加メンバの情報を返します。
	 * 
	 * @return			参加メンバの情報
	 */
	public ClientInfo getClientInfo() {
		return this.clientInfo;
	}

	/*
	 *  (非 Javadoc)
	 * @see jp.valtech.bts.ui.navigator.BtsTreeNode#getNodeKey()
	 */
	public String getNodeKey() {
		return clientInfo.getClientAddress();
	}

	/*
	 *  (非 Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if(obj instanceof MemberNode) {
			MemberNode that = (MemberNode)obj;
			return clientInfo.equals(that.getClientInfo());
		}
		return false;
		
	}
	
}
