/***********************************************************************
 * Copyright(C) 2006 Valtech Co.,Ltd.
 * All Rights Reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 ***********************************************************************/
package jp.valtech.bts.ui.navigator;

import java.util.ArrayList;
import java.util.List;

import jp.valtech.bts.ui.BtsPlugin;


/**
 * XMLにプロジェクト情報を登録します。
 * 
 * @author		<A href="mailto:s_imai@valtech.jp">S.Imai</A>
 * @version	Ver.0.8
 */
public class ProjectConfigManager {

	/** ダイアログセッティング生成 */
	private static IProjectDialogSettings setting = BtsPlugin.getInstance().getProjectDialogSettings();
	
	/** プロジェクトキー */
	public static final String KEY_PROJECT = "PROJECT";
	
	/** ユーザ名キー */
	public static final String KEY_USER = "USER";
	
	/** SSIDキー */
	public static final String KEY_SSID = "SSID";

	/** メール通知チェックキー */
	public static final String KEY_MAILCHECK = "MAILCHECK";
	
	/** SMTPサーバ名キー */
	public static final String KEY_SMTP = "SMTP";
	
	/** 差出人メールアドレスキー */
	public static final String KEY_SENDER = "SENDER";
	
	/** 送信先メールアドレスキー */
	public static final String KEY_RECIPIENT = "RECIPIENT";
	
	/** タイトルプレフィックスキー */
	public static final String KEY_PREFIX = "PREFIX";
	
	/** カテゴリキー */
	public static final String KEY_CATEGORY = "CATEGORY";
	
	/** 優先度キー */
	public static final String KEY_PRIORITY = "PRIORITY";
	
	/** 担当者キー */
	public static final String KEY_ASSIGNED = "ASSIGNED";
	
	/** 投票数チェックキー */
	public static final String KEY_VOTECHECK = "VOTECHECK";
	
	/** 投票数キー */
	public static final String KEY_VOTE = "VOTE";

	/** 完了期限チェックキー */
	public static final String KEY_UNTILDEADLINECHECK = "UNTILDEADLINECHECK";
	
	/** 完了期限キー */
	public static final String KEY_UNTILDEADLINE = "UNTILDEADLINE";
	
	/** 固定同期処理チェックキー */
	public static final String KEY_FIXEDSYNCCHECK = "FIXEDSYNCCHECK";
	
	/** アドレス1番目キー */
	public static final String KEY_ADDRESS1 = "ADDRESS1";
	
	/** アドレス2番目キー */
	public static final String KEY_ADDRESS2 = "ADDRESS2";
	
	/** アドレス3番目キー */
	public static final String KEY_ADDRESS3 = "ADDRESS3";
	
	/** アドレス4番目キー */
	public static final String KEY_ADDRESS4 = "ADDRESS4";
	
	public static final String KEY_PORT = "PORT";
	
	/** 自動同期処理チェックキー */
	public static final String KEY_AUTOSYNCCHECK = "AUTOSYNCCHECK";
	
	/** 通常の同期ラジオキー */
	public static final String KEY_NORMALSYNCRADIO = "NORMALSYNCRADIO";
	
	/** 端末指定同期ラジオキー */
	public static final String KEY_APPOINTSYNCRADIO = "APPOINTSYNCRADIO";
	
	
	/**
	 * プロジェクト情報を保存します。
	 * @param		config		プロジェクト情報
	 */
	public static void save(ProjectConfig config){

		// セクション追加
		IProjectDialogSettings section = setting.addNewSection(config.getSsid());

		// セクションにプロジェクト情報をセット
		setProjectConfig(section, config);
		
		// XMLに登録
		setting.addSection(section);
	}
	
	/**
	 * プロジェクト情報を更新します。
	 * @param		oldConfig		旧プロジェクト情報
	 * @param		newConfig		新しいプロジェクト情報
	 */
	public static void modify(ProjectConfig oldConfig, ProjectConfig newConfig) {

		// 更新するプロジェクト情報のセクション取得
		IProjectDialogSettings section = setting.getSection(newConfig.getSsid());
		
		// 新しいプロジェクト情報を上書き更新
		setProjectConfig(section, newConfig);
	}
	
	/**
	 * セクションにプロジェクト情報をセットします。
	 */
	private static void setProjectConfig(IProjectDialogSettings section, ProjectConfig config) {

		section.put(KEY_PROJECT, config.getProjectName());					// プロジェクト名
		section.put(KEY_USER, config.getUserName());						// ユーザー名
		section.put(KEY_SSID, config.getSsid());							// SSID	
		section.put(KEY_MAILCHECK, config.isMailCheck());					// メール通知チェック
		section.put(KEY_SMTP, config.getSmtp());							// SMTPサーバ名
		section.put(KEY_SENDER, config.getSender());						// 差出人メールアドレス
		section.put(KEY_RECIPIENT, config.getRecipient());					// 送信先メールアドレス
		section.put(KEY_PREFIX, config.getPrefix());						// タイトルプレフィックス
		section.put(KEY_CATEGORY, config.getCategory());					// カテゴリ
		section.put(KEY_PRIORITY, config.getPriority());					// 優先度
		section.put(KEY_ASSIGNED, config.getAssigned());					// 担当者
		section.put(KEY_VOTECHECK, config.isVoteCheck());					// 投票数チェック
		section.put(KEY_VOTE, config.getVote());							// 投票数
		section.put(KEY_UNTILDEADLINECHECK, config.isUntilDeadLineCheck()); // 完了期限チェック
		section.put(KEY_UNTILDEADLINE, config.getUntilDeadLine());			// 完了期限までの日数	
		section.put(KEY_FIXEDSYNCCHECK, config.isFixedSyncCheck());			// 固定同期処理チェック
		section.put(KEY_ADDRESS1, config.getAddress1());					// アドレス1番目
		section.put(KEY_ADDRESS2, config.getAddress2());					// アドレス2番目
		section.put(KEY_ADDRESS3, config.getAddress3());					// アドレス3番目
		section.put(KEY_ADDRESS4, config.getAddress4());					// アドレス4番目
		section.put(KEY_PORT, config.getPort());							// ポート番号
		section.put(KEY_AUTOSYNCCHECK, config.isAutoSyncCheck());			// 自動同期処理チェック
		section.put(KEY_NORMALSYNCRADIO, config.isNormalSyncRadio());		// 通常の同期ラジオ
		section.put(KEY_APPOINTSYNCRADIO, config.isAppointSyncRadio());		// 端末指定同期ラジオ
	}
	
	
	/**
	 * 登録済みプロジェクト情報を取得します。
	 * @param		ssid
	 * @return		プロジェクト情報
	 */
	public static ProjectConfig getProjectConfig(String ssid) {
		// 全ての登録済みプロジェクト情報を取得
		ProjectConfig[] configs = ProjectConfigManager.getProjectConfigs();
		for (int i=0; i<configs.length; i++){
			ProjectConfig config = configs[i];
			// SSIDが一致するプロジェクト情報を戻す
			if(config.getSsid().equals(ssid)){
				return config;
			}
		}
		return null;
	}
	
	/**
	 * 全ての登録済みプロジェクト情報を取得します。
	 * @return		プロジェクト情報
	 */
	public static ProjectConfig[] getProjectConfigs() {
		
		IProjectDialogSettings[] sections = setting.getSections();

		// リスト生成
		List list = new ArrayList(sections.length);

		// セクションの値をリストに追加
		for (int i = 0; i < sections.length; i++) {
			IProjectDialogSettings settings = sections[i];
			ProjectConfig config = new ProjectConfig();
			config.setProjectName(settings.get(KEY_PROJECT));
			config.setUserName(settings.get(KEY_USER));
			config.setSsid(settings.get(KEY_SSID));
			config.setMailCheck(settings.getBoolean(KEY_MAILCHECK));
			config.setSmtp(settings.get(KEY_SMTP));
			config.setSender(settings.get(KEY_SENDER));
			config.setRecipient(settings.get(KEY_RECIPIENT));
			config.setPrefix(settings.get(KEY_PREFIX));
			config.setCategory(settings.get(KEY_CATEGORY));
			config.setPriority(settings.get(KEY_PRIORITY));
			config.setAssigned(settings.get(KEY_ASSIGNED));
			config.setVoteCheck(settings.getBoolean(KEY_VOTECHECK));
			config.setVote(settings.get(KEY_VOTE));
			config.setUntilDeadLineCheck(settings.getBoolean(KEY_UNTILDEADLINECHECK));
			config.setUntilDeadLine(settings.get(KEY_UNTILDEADLINE));		
			config.setFixedSyncCheck(settings.getBoolean(KEY_FIXEDSYNCCHECK));
			config.setAddress1(settings.get(KEY_ADDRESS1));
			config.setAddress2(settings.get(KEY_ADDRESS2));
			config.setAddress3(settings.get(KEY_ADDRESS3));
			config.setAddress4(settings.get(KEY_ADDRESS4));
			config.setPort(settings.get(KEY_PORT));
			config.setAutoSyncCheck(settings.getBoolean(KEY_AUTOSYNCCHECK));
			config.setNormalSyncRadio(settings.getBoolean(KEY_NORMALSYNCRADIO));
			config.setAppointSyncRadio(settings.getBoolean(KEY_APPOINTSYNCRADIO));
			
			list.add(config);
		}
		return (ProjectConfig[]) list.toArray(new ProjectConfig[0]);
	}
	

	/**
	 * 指定されたSSIDをもつセクションを削除します。
	 * 
	 * @param ssid
	 */
	public static void remove(String ssid) {
		setting.removeSection(ssid);
	}
	
	
}
